/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __ZFILE_A
#define __ZFILE_A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#ifndef ___PSTDIO_A
#include "_pstdio.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define bcopyFile(cnt,sz,bsz,s1,s2,n1,n2,re,we) \
    do                                          \
    {                                           \
      zoff_t _size = sz;                        \
      char _buf[bsz];                           \
                                                \
      cnt->success = True;                      \
                                                \
      while( _size > 0L )                       \
      {                                         \
	unsigned int count = (_size > sizeof( _buf )) ? sizeof( _buf ) : (unsigned int) _size; \
                                                \
        if( fread( _buf, count, 1, s1) != 1 )   \
        {                                       \
          cnt->errorCode = re;                  \
          cnt->errorPtr = n1;                   \
          cnt->success = False;                 \
          break;                                \
        }                                       \
						\
        if( fwrite( _buf, count, 1, s2) != 1 )  \
        {                                       \
          cnt->errorCode = we;                  \
          cnt->errorPtr = n2;                   \
          cnt->success = False;                 \
          break;                                \
        }                                       \
                                                \
        _size -= count;                         \
      }                                         \
    } while( 0 )

/* File names */
char *zFileName( const char *name );
Boolean zIsFullFileName( const char *name );
char *zMakeFileName( char *buf, int bufSize, const char *path1, const char *path2);

/* File exist */
#define fefExist             0x0001u
#define fefFileExist         0x0002u
#define fefDirExist          0x0004u

enum
{
  fesOk = 0,
  fesStatError,
  fesNotExist,
  fesInvalidPrefix,
  fesPrefixRights,
  fesNotRegularFile,
  fesNotDirectory
};

int zFileExist( const char *path, unsigned char flags, void *pStatBuf);

/* Temporary files */
struct zcontext_t;

char *zMakeTempName( struct zcontext_t *cnt, char *buf, int bufSize,
    const char *path, Boolean pathIsFile);
FILE *zTempFile( struct zcontext_t *cnt, char *buf, int bufSize, const char *tempDir);

struct ztempfile_t
{
  FILE *stream;
  const char *name;
  zoff_t size;
};

void zInitTempFile( struct ztempfile_t *tempFile );
Boolean zOpenTempFile( struct zcontext_t *cnt, struct ztempfile_t *tempFile, const char *tempDir);
void zCloseTempFile( struct zcontext_t *cnt, struct ztempfile_t *tempFile);
void zExchangeTempFile( struct ztempfile_t *temp1, struct ztempfile_t *temp2);

/* I/O buffer */
#ifndef Z_VBUF_SIZE
#if defined( __MSDOS__ ) || defined( __WIN32__ ) || defined( __OS2__ )
#define Z_VBUF_SIZE                   16*1024
#else
#define Z_VBUF_SIZE                   -1
#endif
#endif
void zSetFileBuffer( FILE *stream, char *buf, int size);

/* Rewrite */
typedef Boolean (*zrewritefile_t)( struct zcontext_t *, FILE *, FILE *, void *);
Boolean zRewriteFile( struct zcontext_t *cnt, const char *inFileName, const char *outFileName,
    zrewritefile_t rewrite, void *info);

/* Directory tree */
struct zstrcoll_t;

struct zprocdir_t
{
  Boolean (*checkDir)( struct zcontext_t *cnt, const char *dirName, struct zstrcoll_t *fileList, void *info, unsigned int flags);
  Boolean (*processFile)( struct zcontext_t *cnt, const char *fileName, void *fileInfo, void *info);
  Boolean (*printMessage)( struct zcontext_t *cnt, int messageCode, const char *name);
};

enum
{
  dpmDirOpenError,
  dpmStatFileError,
  dpmFileAccess
};

#define pdtStopOnError                0x0001u
#define pdtDontSort                   0x0002u
#define pdtCheckDirContent            0x0004u
#define pdtCheckDirFiles              0x0008u
#define pdtOneLevel                   0x0010u
#define pdtAsIs                       0x0020u
#define pdtIgnoreSymLinks             0x0040u
#define pdtDirectoryFirst             0x0080u
#define pdtProcessNamedPipe           0x0100u
#define pdtProcessCharacterSpecial    0x0200u
#define pdtProcessBlockSpecial        0x0400u
#define pdtProcessSocket              0x0800u
#define pdtProcessRegular             0x1000u
#define pdtProcessUnknown             0x2000u
#define pdtProcessDirectory           0x4000u
#define pdtProcessAll                 0x7f00u
#define pdtProcessAllButDirs          0x3f00u
#define pdtNoSymLinkDirs              0x8000u

enum
{
  dftDirectory = 1,
  dftNamedPipe,
  dftCharacterSpecial,
  dftBlockSpecial,
  dftSocket,
  dftRegular,
  dftUnknown
};

Boolean zProcessDirectoryTree( struct zcontext_t *cnt, const char *dirName,
    struct zprocdir_t *procs, void *info, unsigned int flags);

/* Memory mapping */
enum
{
  ZFILEOBJECT_ERRORCODE_OPEN = 0,
  ZFILEOBJECT_ERRORCODE_SEEK,
  ZFILEOBJECT_ERRORCODE_TELL,
  ZFILEOBJECT_ERRORCODE_STAT,
  ZFILEOBJECT_ERRORCODE_ZERO_LENGTH,
  ZFILEOBJECT_ERRORCODE_MMAP,
  ZFILEOBJECT_ERRORCODE_READ,
  ZFILEOBJECT_ERRORCODE_WRITE,
  ZFILEOBJECT_ERRORCODE_EOF,
  ZFILEOBJECT_ERRORCODE_INVALID_FORMAT,
  ZFILEOBJECT_ERRORCODE_LAST
};

struct zfileobject_t
{
  struct zcontext_t *context;
  unsigned int flags;
  const char *name;
  const char *alias;
  FILE *stream;
  const unsigned zint_t *errs;
#if defined( USE_MMAP ) && defined( HAVE_MMAP )
  unsigned char *addr;
  int offset;
  int size;
#else
  zoff_t offset;
  zoff_t size;
#endif
  int lastLength;
};

#define zfoWriteMode                   0x0001u
#define zfoAlloced                     0x0002u
#define zfoMapped                      0x0004u
#define zfoMakeDup                     0x0100u
#define zfoNoMap                       0x0200u
/* XXX: ࠧ  ⨨ 䠩   ஢ */
#define zfoSharedLock                  0x0000u
#define zfoExclusiveLock               0x0000u
#define ZFILEOBJECT_EXTERNAL_FLAGS     (zfoMakeDup | zfoNoMap | zfoSharedLock | zfoExclusiveLock)

void zFileObjectInit( struct zcontext_t *cnt, struct zfileobject_t *fo,
    const char *name, const char *alias, unsigned int flags,
    const unsigned zint_t *errs);
void zFileObjectFree( struct zfileobject_t *fo );

Boolean zFileObjectOpen( struct zfileobject_t *fo, unsigned int flags);
void zFileObjectClose( struct zfileobject_t *fo );

Boolean zFileObjectSeek( struct zfileobject_t *fo, zoff_t offset);
zoff_t zFileObjectTell( struct zfileobject_t *fo );
zoff_t zFileObjectSize( struct zfileobject_t *fo, Boolean restore);
unsigned char *zFileObjectRead( struct zfileobject_t *fo, unsigned char *buf, int length, Boolean virt);
char *zFileObjectGets( struct zfileobject_t *fo, char *buf, int size, Boolean virt);

/* Other */
Boolean zCheckTempDir( struct zcontext_t *cnt, const char *tempDir);
char *zReadFileString( struct zcontext_t *cnt, const char *fileName,
    const char *fileAlias, char *buf, int size);
Boolean zCreateDirectory( struct zcontext_t *cnt, const char *dirName, Boolean isFileName);

#ifdef __cplusplus
}
#endif

#endif
