/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __ZERROR_A
#define __ZERROR_A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define ZERROR_COPY(dst,src) \
  do                         \
  {                          \
    (dst)->errorCode = (src)->errorCode; \
    (dst)->errorPtr = (src)->errorPtr; \
    (dst)->errorIntParam = (src)->errorIntParam; \
    (dst)->errorIntParam2 = (src)->errorIntParam2; \
    (dst)->errorStrParam = (src)->errorStrParam; \
    (dst)->errorStrParam2 = (src)->errorStrParam2; \
  } while( 0 )

void zDefaultPrintError( struct zcontext_t *cnt, unsigned zint_t errorCode, const char *name);
ZAPI(void) zSetErrorHandler( struct zcontext_t *cnt, zprinterror_t handler);

#define zefCodeMask                    __ZINT(0x0000ffffu)
#define zefGeneral                     __ZINT(0x00010000u)
#define zefSystem                      __ZINT(0x00020000u)
#define zefWarning                     __ZINT(0x00040000u)
#define zefSpecial                     __ZINT(0x00080000u)
#define zefDebug                       __ZINT(0x00100000u)
#define zefNoHeader                    __ZINT(0x00200000u)
#define zefCGI                         __ZINT(0x01000000u)
#define zefAccount                     __ZINT(0x02000000u)
#define zefDatabase                    __ZINT(0x04000000u)
#define zefUser1                       __ZINT(0x10000000u)
#define zefUser2                       __ZINT(0x20000000u)
#define zefUser3                       __ZINT(0x40000000u)
#define zefUser4                       __ZINT(0x80000000u)

#define _zErrorCode(x)                 ((int) ((x) & zefCodeMask))

enum
{
  zecNone = 0,
  zecInetArea,
  zecInternalError,
  zecExternalError,
  zecInvalidValue,
  zecValueRange,
  zecSameValue,
  zecNotInited,
  zecNotSupported,
  zecNoMemory,
  zecSystemTime,
  zecTimeValue,
  zecTimeString,
  zecUnknownCharset,
  zecBufferLimit,
  zecInvalidStringFormat,
  zecDataError,
  zecProcCreate,
  zecTempFileName,
  zecZeroLengthFile,
  zecUnexpectedFileEnd,
  zecFileFormat,
  zecFileId,
  zecFileSize,
  zecFileLength,
  zecFileOpen,
  zecFileTell,
  zecFileSeek,
  zecFileStat,
  zecFileLock,
  zecFileRead,
  zecFileWrite,
  zecFileRename,
  zecFileAccess,
  zecFileExist,
  zecFileMmap,
  zecFileDup,
  zecTempFileFormat,
  zecTempFileOpen,
  zecTempFileTell,
  zecTempFileSeek,
  zecTempFileStat,
  zecTempFileRead,
  zecTempFileWrite,
  zecTempFileRename,
  zecTempDirNotExist,
  zecTempDirRights,
  zecTempDirIsntDir,
  zecPipeCreate,
  zecDirCreate,
  zecDirOpen,
  zecNotDirectory,
  zecNotRegularFile,
  zecInvalidPattern,
  zecConfFileOpen,
  zecConfInvalidStringFormat,
  zecConfUnknownSection,
  zecConfUnknownKeyword,
  zecConfInvalidValue,
  zecNeedRecursive,
  zecLastError,
  zecDBFSize = 100,
  zecDBFFieldCount,
  zecDBFFieldSize,
  zecDBFUnknownFieldType,
  zecDBFId,
  zecDBFEntrySize,
  zecDBFInvalidEntrySize,
  zecDBFInvalidEntryCount,
  zecDBFInvalidHeaderSize,
  zecDBFCommentFileSize,
  zecDBFBlockCount,
  zecDBFBlockSize,
  zecDBFNoSuchField,
  zecLast = 200
};

#define zerNone                        zecNone
#define zerInetArea                    (zefGeneral | zecInetArea)
#define zerInternalError               (zefGeneral | zecInternalError)
#define zerExternalError               (zefGeneral | zecExternalError)
#define zerInvalidValue                (zefGeneral | zecInvalidValue)
#define zerValueRange                  (zefGeneral | zecValueRange)
#define zerSameValue                   (zefGeneral | zecSameValue)
#define zerNotInited                   (zefGeneral | zecNotInited)
#define zerNotSupported                (zefGeneral | zecNotSupported)
#define zerNoMemory                    (zefGeneral | zecNoMemory)
#define zerSystemTime                  (zefGeneral | zecSystemTime)
#define zerTimeValue                   (zefGeneral | zecTimeValue)
#define zerTimeString                  (zefGeneral | zecTimeString)
#define zerUnknownCharset              (zefGeneral | zecUnknownCharset)
#define zerBufferLimit                 (zefGeneral | zecBufferLimit)
#define zerInvalidStringFormat         (zefGeneral | zecInvalidStringFormat)
#define zerDataError                   (zefGeneral | zecDataError)
#define zerProcCreate                  (zefGeneral | zecProcCreate)
#define zerTempFileName                (zefGeneral | zecTempFileName)
#define zerZeroLengthFile              (zefGeneral | zecZeroLengthFile)
#define zerUnexpectedFileEnd           (zefGeneral | zecUnexpectedFileEnd)
#define zerFileFormat                  (zefGeneral | zecFileFormat)
#define zerFileId                      (zefGeneral | zecFileId)
#define zerFileSize                    (zefGeneral | zecFileSize)
#define zerFileLength                  (zefGeneral | zecFileLength)
#define zerFileOpen                    (zefGeneral | zecFileOpen)
#define zerFileTell                    (zefGeneral | zecFileTell)
#define zerFileSeek                    (zefGeneral | zecFileSeek)
#define zerFileStat                    (zefGeneral | zecFileStat)
#define zerFileLock                    (zefGeneral | zecFileLock)
#define zerFileRead                    (zefGeneral | zecFileRead)
#define zerFileWrite                   (zefGeneral | zecFileWrite)
#define zerFileRename                  (zefGeneral | zecFileRename)
#define zerFileAccess                  (zefGeneral | zecFileAccess)
#define zerFileExist                   (zefGeneral | zecFileExist)
#define zerFileMmap                    (zefGeneral | zecFileMmap)
#define zerFileDup                     (zefGeneral | zecFileDup)
#define zerTempFileFormat              (zefGeneral | zecTempFileFormat)
#define zerTempFileOpen                (zefGeneral | zecTempFileOpen)
#define zerTempFileTell                (zefGeneral | zecTempFileTell)
#define zerTempFileSeek                (zefGeneral | zecTempFileSeek)
#define zerTempFileStat                (zefGeneral | zecTempFileStat)
#define zerTempFileRead                (zefGeneral | zecTempFileRead)
#define zerTempFileWrite               (zefGeneral | zecTempFileWrite)
#define zerTempFileRename              (zefGeneral | zecTempFileRename)
#define zerTempDirNotExist             (zefGeneral | zecTempDirNotExist)
#define zerTempDirRights               (zefGeneral | zecTempDirRights)
#define zerTempDirIsntDir              (zefGeneral | zecTempDirIsntDir)
#define zerPipeCreate                  (zefGeneral | zecPipeCreate)
#define zerDirCreate                   (zefGeneral | zecDirCreate)
#define zerDirOpen                     (zefGeneral | zecDirOpen)
#define zerNotDirectory                (zefGeneral | zecNotDirectory)
#define zerNotRegularFile              (zefGeneral | zecNotRegularFile)
#define zerInvalidPattern              (zefGeneral | zecInvalidPattern)
#define zerConfFileOpen                (zefGeneral | zecConfFileOpen)
#define zerConfInvalidStringFormat     (zefGeneral | zecConfInvalidStringFormat)
#define zerConfUnknownSection          (zefGeneral | zecConfUnknownSection)
#define zerConfUnknownKeyword          (zefGeneral | zecConfUnknownKeyword)
#define zerConfInvalidValue            (zefGeneral | zecConfInvalidValue)
#define zerNeedRecursive               (zefGeneral | zecNeedRecursive)
#define zerDBFSize                     (zefGeneral | zecDBFSize)
#define zerDBFFieldCount               (zefGeneral | zecDBFFieldCount)
#define zerDBFFieldSize                (zefGeneral | zecDBFFieldSize)
#define zerDBFUnknownFieldType         (zefGeneral | zecDBFUnknownFieldType)
#define zerDBFId                       (zefGeneral | zecDBFId)
#define zerDBFEntrySize                (zefGeneral | zecDBFEntrySize)
#define zerDBFInvalidEntrySize         (zefGeneral | zecDBFInvalidEntrySize)
#define zerDBFInvalidEntryCount        (zefGeneral | zecDBFInvalidEntryCount)
#define zerDBFInvalidHeaderSize        (zefGeneral | zecDBFInvalidHeaderSize)
#define zerDBFCommentFileSize          (zefGeneral | zecDBFCommentFileSize)
#define zerDBFBlockCount               (zefGeneral | zecDBFBlockCount)
#define zerDBFBlockSize                (zefGeneral | zecDBFBlockSize)
#define zerDBFNoSuchField              (zefGeneral | zecDBFNoSuchField)
#define zerLast                        zecLast

ZAPI(char *) zSystemErrorString( unsigned zint_t errorCode, char *buf, int size);

ZEXT(const char * const) zErrorEnglishFormats[zecLastError+1];
#if defined( RUSSIAN_SUPPORT )
ZEXT(const char * const) zErrorRussianFormats[zecLastError+1];
#endif
#if defined( RUSSIAN_SUPPORT ) && defined( UKRAINIAN_SUPPORT )
ZEXT(const char * const) zErrorUkrainianFormats[zecLastError+1];
#endif

ZAPI(char *) zGetErrorString( struct zcontext_t *cnt, char *buffer, int size,
     unsigned zint_t errorCode, const char *name);

#ifdef __cplusplus
}
#endif

#endif
