/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __ZDEBUG_A
#define __ZDEBUG_A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#ifndef ___PSTDIO_A
#include "_pstdio.h"
#endif

#define zdaInet                        0x0001u
#define zdaUser1                       0x1000u
#define zdaUser2                       0x2000u
#define zdaUser3                       0x4000u
#define zdaUser4                       0x8000u

enum
{
  ZDEBUG_LEVEL_NONE = 0,
  ZDEBUG_LEVEL_CALLS,
  ZDEBUG_LEVEL_ARGS,
  ZDEBUG_LEVEL_MESSAGE,
  ZDEBUG_LEVEL_INFO,
  ZDEBUG_LEVEL_LAST
};

enum
{
  ZDEBUG_TARGET_DEFAULT,
  ZDEBUG_TARGET_IN,
  ZDEBUG_TARGET_OUT,
  ZDEBUG_TARGET_ARGS,
  ZDEBUG_TARGET_ALARM,
};

#ifdef ZDEBUG

#define ZDEBUG_MSG(cnt,l,a,msg) \
    do                          \
    {                           \
      if( zCheckFlags( (cnt)->debugArea, (a)) && (cnt)->debugLevel >= (l) ) \
        zdebug msg;             \
    } while( 0 )

#define ZDEBUG_IN(cnt,a,progName) \
    do                            \
    {                             \
      (cnt)->debugProgLevel++;    \
      if( zCheckFlags( (cnt)->debugArea, (a)) && (cnt)->debugLevel >= ZDEBUG_LEVEL_CALLS ) \
        zdebug( (cnt), ZDEBUG_TARGET_IN, "%s", progName); \
    } while( 0 )

#define ZDEBUG_OUT(cnt,a,progName) \
    do                             \
    {                              \
      if( zCheckFlags( (cnt)->debugArea, (a)) && (cnt)->debugLevel >= ZDEBUG_LEVEL_CALLS ) \
        zdebug( (cnt), ZDEBUG_TARGET_OUT, "%s", progName); \
      if( (cnt)->debugProgLevel > 0 ) (cnt)->debugProgLevel--; \
    } while( 0 )

#define ZDEBUG_OUT_P(cnt,a,progName,rv) \
    do                                  \
    {                                   \
      if( zCheckFlags( (cnt)->debugArea, (a)) && (cnt)->debugLevel >= ZDEBUG_LEVEL_CALLS ) \
        zdebug( (cnt), ZDEBUG_TARGET_OUT, "%s returns %p", progName, ((void *) (rv))); \
      if( (cnt)->debugProgLevel > 0 ) (cnt)->debugProgLevel--; \
    } while( 0 )

#define ZDEBUG_OUT_B(cnt,a,progName,rv) \
    do                                  \
    {                                   \
      if( zCheckFlags( (cnt)->debugArea, (a)) && (cnt)->debugLevel >= ZDEBUG_LEVEL_CALLS ) \
        zdebug( (cnt), ZDEBUG_TARGET_OUT, "%s returns %s", progName, ((Boolean) (rv)) ? "True" : "False"); \
      if( (cnt)->debugProgLevel > 0 ) (cnt)->debugProgLevel--; \
    } while( 0 )

#define ZDEBUG_OUT_D(cnt,a,progName,rv) \
    do                                  \
    {                                   \
      if( zCheckFlags( (cnt)->debugArea, (a)) && (cnt)->debugLevel >= ZDEBUG_LEVEL_CALLS ) \
        zdebug( (cnt), ZDEBUG_TARGET_OUT, "%s returns %" _ZINT_FORMAT "d", progName, ((zint_t) (rv))); \
      if( (cnt)->debugProgLevel > 0 ) (cnt)->debugProgLevel--; \
    } while( 0 )

#define ZDEBUG_OUT_U(cnt,a,progName,rv) \
    do                                  \
    {                                   \
      if( zCheckFlags( (cnt)->debugArea, (a)) && (cnt)->debugLevel >= ZDEBUG_LEVEL_CALLS ) \
        zdebug( (cnt), ZDEBUG_TARGET_OUT, "%s returns %" _ZINT_FORMAT "u", progName, ((unsigned zint_t) (rv))); \
      if( (cnt)->debugProgLevel > 0 ) (cnt)->debugProgLevel--; \
    } while( 0 )

#define ZDEBUG_OUT_X(cnt,a,progName,rv) \
    do                                  \
    {                                   \
      if( zCheckFlags( (cnt)->debugArea, (a)) && (cnt)->debugLevel >= ZDEBUG_LEVEL_CALLS ) \
        zdebug( (cnt), ZDEBUG_TARGET_OUT, "%s returns %" _ZINT_FORMAT "x", progName, ((unsigned zint_t) (rv))); \
      if( (cnt)->debugProgLevel > 0 ) (cnt)->debugProgLevel--; \
    } while( 0 )

#else

#define ZDEBUG_MSG(cnt,l,a,msg)
#define ZDEBUG_IN(cnt,a,progName)
#define ZDEBUG_OUT(cnt,a,progName)

#define ZDEBUG_OUT_P(cnt,a,progName,rv)
#define ZDEBUG_OUT_B(cnt,a,progName,rv)
#define ZDEBUG_OUT_D(cnt,a,progName,rv)
#define ZDEBUG_OUT_U(cnt,a,progName,rv)
#define ZDEBUG_OUT_X(cnt,a,progName,rv)

#endif

void zDebugInit( struct zcontext_t *cnt, int level, unsigned zint_t area, FILE *stream);
void zdebug( struct zcontext_t *cnt, int target, const char *fmt, ...);

#endif
