/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __ZLIB_A
#define __ZLIB_A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#ifndef ___PSTDIO_A
#include "_pstdio.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

struct zcontext_t
{
/* Errors */
  unsigned zint_t errorCode;
  const char * const *errorFormats;
  const char *errorPtr;
  int errorIntParam;
  int errorIntParam2;
  const char *errorStrParam;
  const char *errorStrParam2;
  zprinterror_t printError;
  zprinterror_t printErr;

/* Memory allocation & collections */
  int allocCount;
  zmemfail_t allocFail;
  int lastStringSize;
  unsigned int lastCollectionIndex;
  Boolean lastDuplicate;
#if defined( __MSVC__ )
  unsigned long hHeap;
#endif

/* I/O */
  unsigned int ioFlags;
  unsigned int ioDirection;
  int localCharset;
  int remoteCharset;
  int remoteStrictCharset;
  char *convTable;           /* remote -> local */
  char *recodeTable;         /* local -> remote */
  char *recodeStrictTable;   /* local -> remote */
  FILE *input;
  FILE *output;
  struct zstrbuf_t *ioStrbuf;
  zwrite_t ioWrite;
  zflush_t ioFlush;

/* zvprintf's */
  char *ioBuf;
  int ioBufSize;
  int ioBufLength;

/* Config */
  Boolean confSuccess;
  int confLineNumber;
  int confSectionLineNumber;
  struct zconfsec_t *confSection;
  unsigned int confAreaFlags;
  const char *confName;
  const unsigned zint_t *confErrors;
  zprocessstring_t processConfigString;

/* File operations */
  zint_t tmpFileNumber;
  zint_t tmpFileMaxCount;
  Boolean tmpFileSuccess;
  Boolean rewriteTextMode;
  Boolean tempFileTextMode;

/* Inet data */
  int inetError;
  int inetErrorArea;
  Boolean inetStarted;
  Boolean inetDebug;

/* Debug */
  unsigned zint_t debugArea;
  int debugLevel;
  unsigned int debugProgLevel;
  FILE *debugStream;

/* Application's */
  Boolean success;
  char *nextItem;
  unsigned int runFlags;
  unsigned int patternFlags;
  int verboseLevel;
  struct zcgidata_t *cgiData;
  int timeArea;
  int language;

/* Heaps */
  void *heap1;
  void *heap2;
  void *heap3;

/* Internal info */
  void *info1;
  void *info2;
  void *info3;

/* User data */
  void *userData;
  void *userData2;
  void *userData3;
};

/* #define ZCONTEXT_IOFLAG_CHARSET_PROCESSED        0x0001u */
#define ZCONTEXT_IOFLAG_CHARSET_CONV             0x0002u
#define ZCONTEXT_IOFLAG_CHARSET_RECODE           0x0004u
#define ZCONTEXT_IOFLAG_CHARSET_RECODE_STRICT    0x0008u
#define ZCONTEXT_IOFLAG_STRICT_VALUE             0x0010u
#define ZCONTEXT_IOFLAG_AUTOFLUSH                0x0020u
#define ZCONTEXT_IOFLAG_INTERNAL_BUFFER          0x0040u
#define ZCONTEXT_IOFLAG_NO_INTERNAL_BUFFER       0x0080u

#define ZCONTEXT_RUNFLAG_VERBOSE                 0x0001u
#define ZCONTEXT_RUNFLAG_SYMLINKS                0x0002u
#define ZCONTEXT_RUNFLAG_RECURSIVE               0x0004u
#define ZCONTEXT_RUNFLAG_QUIET                   0x0008u
#define ZCONTEXT_RUNFLAG_FULL_FILE_NAMES         0x0010u

#define zConvTable(cnt) \
    (zCheckFlags( (cnt)->ioFlags, ZCONTEXT_IOFLAG_CHARSET_CONV) ? (cnt)->confTable : NULL)
#define zRecodeTable(cnt) \
    (zCheckFlags( (cnt)->ioFlags, ZCONTEXT_IOFLAG_CHARSET_RECODE) ? (cnt)->recodeTable : NULL)
#define zRecodeStrictTable(cnt) \
    (zCheckFlags( (cnt)->ioFlags, ZCONTEXT_IOFLAG_CHARSET_RECODE_STRICT) ? (cnt)->recodeStrictTable : NULL)

#define zciCreateHeap                  0x0001u
#define zciHeapSerialize               0x0002u

ZAPI(Boolean) zContextInit( struct zcontext_t *cnt, zprinterror_t printError,
    const char * const *errorFormats, zmemfail_t memFail, unsigned int flags);
ZAPI(void) zContextCopy( struct zcontext_t *dest, struct zcontext_t *src);
ZAPI(void) zContextFree( struct zcontext_t *cnt );

enum
{
  zlnEnglish,
#if defined( RUSSIAN_SUPPORT )
  zlnRussian,
#endif
#if defined( RUSSIAN_SUPPORT ) && defined( UKRAINIAN_SUPPORT )
  zlnUkrainian,
#endif
};

enum
{
  ztaNone = 0,
  ztaYear,
  ztaMonth,
  ztaDay,
  ztaHour,
  ztaMinute,
  ztaSecond
};

#ifdef __cplusplus
}
#endif

#endif
