/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __ZCONFIG_A
#define __ZCONFIG_A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

enum
{
  zpcOk = 0,
  zpcNotOk,
  zpcNoMemory,
  zpcNoDelimiter,
  zpcEmptyValue,
  zpcNoKeyword,
  zpcUnknownKeyword,
  zpcNotClosed,
  zpcInvalidValue,
  zpcUnknown
};

enum
{
  ZCONFERR_FILE_OPEN = 0,
  ZCONFERR_UNKNOWN_SECTION,
  ZCONFERR_INVALID_STRING_FORMAT,
  ZCONFERR_UNKNOWN_KEYWORD,
  ZCONFERR_INVALID_VALUE,
  ZCONFERR_LAST
};

struct zconfdef_t
{
  const char *name;
  unsigned int area;
  int (*getValue)( struct zcontext_t *cnt, struct zconfdef_t *cfg, char *value, void *data);
  char **value;
  void *param;
  int offset;
  unsigned zint_t flags;
};

#define ZCONFIG_FLAG_POSITIVE          __ZINT(0x00000100u)
#define ZCONFIG_FLAG_UNSIGNED          __ZINT(0x00000200u)
#define ZCONFIG_FLAG_ZVALUE            __ZINT(0x00000400u)
#define ZCONFIG_FLAG_DONT_OVERWRITE    __ZINT(0x00000800u)
#define ZCONFIG_FLAG_SPECIAL           __ZINT(0x00001000u)
#define ZCONFIG_FLAG_PROCESSED         __ZINT(0x00002000u)
#define ZCONFIG_FLAG_LOWERCASE         __ZINT(0x00004000u)
#define ZCONFIG_FLAG_LEAVE_ESCAPED     __ZINT(0x00008000u)
#define ZCONFIG_FLAG_CHECK_SPACES      __ZINT(0x00010000u)
#define ZCONFIG_FLAG_COMPRESS          __ZINT(0x00020000u)
#define ZCONFIG_FLAG_PARAM_YES         __ZINT(0x00040000u)
#define ZCONFIG_FLAG_PARAM_NO          __ZINT(0x00080000u)
#define ZCONFIG_FLAG_HAS_PARAM         __ZINT(0x00100000u)

struct zconfsec_t
{
  const char *name;
  unsigned int area;
  Boolean (*init)( struct zcontext_t *cnt, struct zconfsec_t *current, unsigned int flags, const char *fileName, void *data);
  Boolean (*process)( struct zcontext_t *cnt, char *line, void *data);
  void (*finish)( struct zcontext_t *cnt, Boolean success, Boolean hasValue, void *data);
  void (*free)( struct zcontext_t *cnt, void *data);
  struct zconfdef_t *table;
};

Boolean zReadConfFile( struct zcontext_t *cnt, const char *fileName,
    const char *fileAlias, struct zconfsec_t *list, unsigned int flags, void *data);
void zFreeConfBlocks( struct zcontext_t *cnt, struct zconfsec_t *list, void *data);

int zProcessConfig( struct zcontext_t *cnt, char *line, struct zconfdef_t *confTable, unsigned int area, void *data);

Boolean zInitDefaultConfig( struct zcontext_t *cnt, struct zconfsec_t *cs, unsigned int flags, const char *fileName, void *data);
void zFinishDefaultConfig( struct zcontext_t *cnt, Boolean success, Boolean hasValue, void *data);
Boolean zProcessDefaultConfig( struct zcontext_t *cnt, char *line, void *data);

int zConfigBooleanValue( struct zcontext_t *cnt,
    struct zconfdef_t *cfg, char *value, void *data);
int zConfigIntegerValue( struct zcontext_t *cnt,
    struct zconfdef_t *cfg, char *value, void *data);
int zConfigTokenValue( struct zcontext_t *cnt,
    struct zconfdef_t *cfg, char *value, void *data);
int zConfigStringValue( struct zcontext_t *cnt,
    struct zconfdef_t *cfg, char *value, void *data);
int zConfigStringListValue( struct zcontext_t *cnt,
    struct zconfdef_t *cfg, char *value, void *data);
int zConfigStatusValue( struct zcontext_t *cnt,
    struct zconfdef_t *cfg, char *value, void *data);

#define ZCONFIG_GET_ARG(cf,tp,ar,dat) \
    if( (cf)->value != NULL )         \
      (ar) = (tp *) (cf)->value;      \
    else if( (cf)->offset < 0 || dat == NULL ) \
      return zpcOk;                   \
    else                              \
      (ar) = (tp *) &((char *) (dat))[(cf)->offset]

#define ZCONFIG_GET_PTR(cf,pt,dat)   ZCONFIG_GET_ARG( cf, char *, pt, dat)
#define ZCONFIG_GET_COLL(cf,col,dat) ZCONFIG_GET_ARG( cf, struct zstrcoll_t, col, dat)

/*
#define ZCONFIG_GET_PTR(cf,pt,dat) \
    if( (cf)->value != NULL )      \
      (pt) = (cf)->value;          \
    else if( (cf)->offset < 0 || dat == NULL ) \
      return zpcOk;                \
    else                           \
      (pt) = (char **) &((char *) (dat))[(cf)->offset]
*/

/*
#define ZCONFIG_GET_COLL(cf,col,dat) \
    if( (cf)->value != NULL )        \
      (col) = (struct zstrcoll_t *) (cf)->value; \
    else if( (cf)->offset < 0 || dat == NULL ) \
      return zpcOk;                  \
    else                             \
      (col) = (struct zstrcoll_t *) &((char *) (dat))[(cf)->offset]
*/

#define ZCONFIG_GET_VALUE(cf,tp,val,dat) \
    if( (cf)->value != NULL )            \
      (val) = *((tp *) (cf)->value);     \
    else if( (dat) != NULL && (cf)->offset >= 0 ) \
      (val) = *((tp *) &((char *) (dat))[(cf)->offset]); \
    else                                 \
      return zpcOk

#define ZCONFIG_SET_VALUE(cf,tp,val,dat) \
    if( (cf)->value != NULL )            \
      *((tp *) (cf)->value) = (val);     \
    else if( (dat) != NULL && (cf)->offset >= 0 ) \
      *((tp *) &((char *) (dat))[(cf)->offset]) = (val)

#ifdef __cplusplus
}
#endif

#endif
