/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __ZCOLL2_A
#define __ZCOLL2_A

#define ZCOLL_SORTED_SEARCH(dc,data,result,index) \
    do                                            \
    {                                             \
      unsigned int lower, upper;                  \
      result = False;                             \
      if( dc->count == 0 )                        \
        lower = 0;                                \
      else for( lower = 0, upper = (dc)->count-1; lower <= upper; ) \
      {                                           \
        register int midpoint = (lower + upper) >> 1; \
        register void *elem = zDataCollectionElem( dc, midpoint); \
        register int cmp;                         \
        __ZCOMPARE( cmp, data, elem);             \
        if( cmp == 0 )                            \
        {                                         \
          result = True;                          \
          lower = midpoint;                       \
          break;                                  \
        }                                         \
        if( cmp > 0 )                             \
          lower = midpoint + 1;                   \
        else if( midpoint == 0 )                  \
          break;                                  \
        else                                      \
          upper = midpoint - 1;                   \
      }                                           \
      index = lower;                              \
    }                                             \
    while( 0 )

#define ZCOLL_SORTED_ADD(dc,data,freeIfDup,succs) \
    do                                            \
    {                                             \
      unsigned int index;                         \
      Boolean duplicate;                          \
                                                  \
      (succs) = True;                             \
      ZCOLL_SORTED_SEARCH( (dc), (data), duplicate, index); \
      (dc)->context->lastDuplicate = duplicate;   \
      (dc)->context->lastCollectionIndex = index; \
                                                  \
      if( duplicate )                             \
      {                                           \
        if( freeIfDup && (dc)->efree != NULL )    \
          (dc)->efree( (dc)->context, (void *) (data)); \
      }                                           \
      else if( (dc)->reserved <= (dc)->count &&   \
               !zDataCollectionResize( (dc), (dc)->count + 1) ) \
        succs = False;                            \
      else                                        \
      {                                           \
        if( index < (dc)->count )                 \
          memmove( zDataCollectionElem( (dc), index+1), \
                   zDataCollectionElem( (dc), index), \
                   (dc)->elemSize * ((dc)->count - index)); \
        memcpy( zDataCollectionElem( (dc), index), (data), (dc)->elemSize); \
        (dc)->count++;                            \
      }                                           \
    } while( 0 )

#endif
