/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __ZCOLL_A
#define __ZCOLL_A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#ifndef ___PSTRING_A
#include "_pstring.h"
#endif

#ifndef __ZALLOC_A
#include "zalloc.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Flags */
#define zcfAlloced                         0x0001u
#define zcfSorted                          0x0002u
#define zcfCheckDuplicate                  0x0004u
#define zcfFreeIfDuplicate                 0x0008u
#define zcfDontAllocMemory                 0x0010u
#define zcfExtended                        0x0020u
#define zcfDontFreeContent                 0x0040u
#define zcfRejectNullString                0x0080u
#define zcfSolid                           0x0100u
#define zcfCaseIndep                       0x0200u
#define zcfFirstInsert                     0x0400u
#define zcfCheckLast                       0x0800u

#define zcfResizeError                     0x1000u
#define zcfResizeStatic                    0x2000u
#define zcfHasDuplicate                    0x4000u
#define zcfAllErrors                       (zcfResizeError | zcfResizeStatic | zcfHasDuplicate)

#define zcfRealCollectionFlags             (zcfSorted | zcfCheckDuplicate |\
                                           zcfDontFreeContent | zcfRejectNullString |\
                                           zcfCaseIndep | zcfFirstInsert |\
                                           zcfCheckLast)

/**************************************************************************/
/*                                                                        */
/*  String buffer                                                         */
/*                                                                        */
/**************************************************************************/

#define ZDEFAULT_STRING_BUFFER_DELTA       256

struct zstrbuf_t
{
  struct zcontext_t *context;
  char *buffer;
  unsigned int size;
  unsigned int length;
  unsigned int delta;
  unsigned int flags;
};

#define ZNULL_STATIC_STRING_BUFFER(cnt,b,s)    { cnt, b, s, 0, 0, 0 }
#define ZNULL_DYNAMIC_STRING_BUFFER(cnt,d)     { cnt, NULL, 0, 0, d, 0 }

#define zStringBufferItself(sb)            ((sb)->buffer)
#define zStringBufferLength(sb)            ((sb)->length)
#define zStringBufferResizable(sb)         ((sb)->delta > 0)
#define zStringBufferAlloced(sb)           zCheckFlags( (sb)->flags, zcfAlloced)
#define zStringBufferError(sb)             zCheckFlags( (sb)->flags, zcfAllErrors)
#define zStringBufferEmpty(sb)             ((sb)->length == 0)
#define zStringBufferFlash(sb)             ((sb)->length = 0)
#define zStringBufferReinit(sb)            ((sb)->length = 0)

#define zStringBufferClear(sb) \
    do                         \
    {                          \
      (sb)->buffer = (char *) zDummyString; \
      (sb)->size = (sb)->length = (sb)->flags = 0; \
    } while( 0 )

Boolean zStringBufferInit( struct zcontext_t *cnt, struct zstrbuf_t *sb,
    char *buf, unsigned int size, unsigned int delta);
void zStringBufferFree( struct zstrbuf_t *sb );

Boolean zStringBufferResize( struct zstrbuf_t *sb, unsigned int newSize);
Boolean zStringBufferStrictResize( struct zstrbuf_t *sb, unsigned int newSize);

Boolean zStringBufferAdd( struct zstrbuf_t *sb, const char *string);
Boolean zStringBufferAddChar( struct zstrbuf_t *sb, int c);
Boolean zStringBufferAddData( struct zstrbuf_t *sb, const char *data, unsigned int length);

Boolean zStringBufferSet( struct zstrbuf_t *sb, const char *string);
Boolean zStringBufferSetData( struct zstrbuf_t *sb, const char *data, unsigned int length);

Boolean zStringBufferShift( struct zstrbuf_t *sb, unsigned int start, int count);

/* old style definition */
#define zPushString(sb,string,separate) \
    do                                  \
    {                                   \
      if( (separate) && (sb)->length > 0 && (sb)->buffer[(sb)->length-1] != ' ' ) \
        zStringBufferAddChar( (sb), ' '); \
      zStringBufferAdd( (sb), (string)); \
    } while( 0 )


/**************************************************************************/
/*                                                                        */
/*  String & param collections                                            */
/*                                                                        */
/**************************************************************************/

#define ZDEFAULT_STRING_COLLECTION_DELTA   16

struct zstrcoll_t
{
  struct zcontext_t *context;
  char **list;
  unsigned int reserved;
  unsigned int count;
  unsigned int delta;
  unsigned int flags;
};

struct zparamcoll_t
{
  struct zcontext_t *context;
  char **list;
  unsigned int reserved;
  unsigned int count;
  unsigned int delta;
  unsigned int flags;
  unsigned int shift;
  zstrcmp_t cmp;
  zdelete_t efree;
};

#define zStringCollectionEmpty(sc)             ((sc)->count == 0)
#define zStringCollectionCount(sc)             ((sc)->count)
#define zStringCollectionResizable(sc)         ((sc)->delta > 0)
#define zStringCollectionError(sc)             zCheckFlags( (sc)->flags, zcfAllErrors)

#define ZNULL_STRING_COLLECTION(cnt,d,f)       { cnt, NULL, 0, 0, (d), ((f) & zcfRealCollectionFlags) }
#define ZNULL_PARAM_COLLECTION(cnt,d,f,s,c,ef) { cnt, NULL, 0, 0, (d), ((f) & zcfRealCollectionFlags), s, c, ef }

Boolean zStringCollectionInit( struct zcontext_t *cnt, struct zstrcoll_t *sc,
    unsigned int size, unsigned int delta, unsigned int flags);
void zStringCollectionFree( struct zstrcoll_t *sc );

Boolean zStringCollectionResize( struct zstrcoll_t *sc, unsigned int newCount);
Boolean zStringCollectionStrictResize( struct zstrbuf_t *sc, unsigned int newCount);

Boolean zStringCollectionAdd( struct zstrcoll_t *sc, const char *string, unsigned int flags);
void zStringCollectionRemove( struct zstrcoll_t *sc, unsigned int index, Boolean freeit);

Boolean zStringCollectionSearch( struct zstrcoll_t *sc, const char *string, unsigned int *pi, Boolean extendedString);
char *zStringCollectionFind( struct zstrcoll_t *sc, const char *string);

Boolean zParamCollectionInit( struct zcontext_t *cnt, struct zparamcoll_t *pc,
    unsigned int size, unsigned int delta, unsigned int flags,
    unsigned int shift, zstrcmp_t cmpf, zdelete_t efree);
Boolean zParamCollectionAdd( struct zparamcoll_t *pc, const char *string,
    char *adds, unsigned int addsSize);

#define zParamCollectionFree(pc) \
    zStringCollectionFree( (struct zstrcoll_t *) (pc) )

/**************************************************************************/
/*                                                                        */
/*  Data collection                                                       */
/*                                                                        */
/**************************************************************************/

#define ZDEFAULT_DATA_COLLECTION_DELTA     16

struct zdatacoll_t
{
  struct zcontext_t *context;
  char *list;
  unsigned int reserved;
  unsigned int count;
  unsigned int delta;
  unsigned int flags;
  unsigned int elemSize;
  zcmp_t cmp;
  zdelete_t efree;
};

#define zDataCollectionEmpty(dc)               ((dc)->count == 0)
#define zDataCollectionCount(dc)               ((dc)->count)
#define zDataCollectionResizable(dc)           ((dc)->delta > 0)
#define zDataCollectionError(dc)               zCheckFlags( (dc)->flags, zcfAllErrors)

#ifdef ZCHECK_COLLECTIONS
#define zDataCollectionElem(dc,e) \
    (((unsigned int) (e) >= (dc)->count) ? NULL : (&(dc)->list[ (dc)->elemSize * (e) ]))
#else
#define zDataCollectionElem(dc,e)              (&(dc)->list[ (dc)->elemSize * (e) ])
#endif

#define ZNULL_DATA_COLLECTION(cnt,d,f,es,c,ef) { cnt, NULL, 0, 0, (d), ((f) & zcfRealCollectionFlags), es, c, ef }

Boolean zDataCollectionInit( struct zcontext_t *cnt, struct zdatacoll_t *dc,
    unsigned int size, unsigned int delta, unsigned int flags,
    unsigned int elemSize, zcmp_t cmp, zdelete_t efree);
void zDataCollectionFree( struct zdatacoll_t *dc );

Boolean zDataCollectionResize( struct zdatacoll_t *dc, unsigned int newCount);
Boolean zDataCollectionStrictResize( struct zdatacoll_t *dc, unsigned int newCount);

Boolean zDataCollectionAdd( struct zdatacoll_t *dc, const void *data, unsigned int flags);
void zDataCollectionRemove( struct zdatacoll_t *dc, unsigned int index, Boolean freeit);

Boolean zDataCollectionSearch( struct zdatacoll_t *dc, const void *data, unsigned int *pi);
void *zDataCollectionFind( struct zdatacoll_t *dc, const void *data);

void zDataCollectionSort( struct zdatacoll_t *dc, zcmp_t cmp, Boolean makeSorted);

/**************************************************************************/
/*                                                                        */
/*  Replace                                                               */
/*                                                                        */
/**************************************************************************/

struct zreplacerule_t
{
  struct zreplacerule_t *next;
  unsigned int flags;
  int type;
  int length1;
  int length2;
  const char *string1;
  const char *string2;
};

struct zreplace_t
{
  struct zcontext_t *context;
  struct zreplacerule_t *rules;
  struct zreplacerule_t *lastr;
  struct zstrbuf_t *ibuf;
};

#define zReplaceEmpty(rc)                      ((rc)->rules == NULL)

#define ZREPLACE_STRING_UNKNOWN     "unknown"
#define ZREPLACE_STRING_BEGINNING   "beginning"
#define ZREPLACE_STRING_ENDING      "ending"
#define ZREPLACE_STRING_STRING      "string"
#define ZREPLACE_STRING_PREPEND     "prepend"
#define ZREPLACE_STRING_APPEND      "append"

#define ZREPLACE_RULE_UNKNOWN       0
#define ZREPLACE_RULE_BEGINNING     1
#define ZREPLACE_RULE_ENDING        2
#define ZREPLACE_RULE_STRING        3
#define ZREPLACE_RULE_PREPEND       4
#define ZREPLACE_RULE_APPEND        5

#define ZREPLACE_FLAG_FIRSTRULE     0x4000u
#define ZREPLACE_FLAG_CASEINDEP     0x8000u
#define ZREPLACE_FLAG_RESERVED      (ZREPLACE_FLAG_FIRSTRULE | ZREPLACE_FLAG_CASEINDEP)

void zReplaceInit( struct zcontext_t *cnt, struct zreplace_t *rpl, struct zstrbuf_t *sb);
void zReplaceFree( struct zreplace_t *rpl );

int zReplaceRuleType( const char *name );
const char *zReplaceRuleName( int type );

Boolean zReplaceRuleAdd( struct zreplace_t *rpl, int type,
    const char *string1, const char *string2, unsigned int flags);
char *zReplaceApply( struct zreplace_t *rpl, const char *string, unsigned int flags);

/***************************************************************************/
/*                                                                         */
/*  Data heap                                                              */
/*                                                                         */
/***************************************************************************/

struct zdataheap_t
{
  struct zcontext_t *context;
  struct zdataheap_block_t *blocks;
  struct zdataheap_item_t *items;
  unsigned int itemSize;
  unsigned int blockSize;
};

void zDataHeapInit( struct zcontext_t *cnt, struct zdataheap_t *dh,
    unsigned int itemSize, unsigned int delta);
void zDataHeapFree( struct zdataheap_t *dh );

void *zDataHeapItemNew( struct zdataheap_t *dh );
void zDataHeapItemFree( struct zdataheap_t *dh, void *data);

/***************************************************************************/
/*                                                                         */
/*  Red-black tree                                                         */
/*                                                                         */
/***************************************************************************/

struct zrbnode_t;
struct zrbnode_block_t;

struct zrbtree_t
{
  struct zcontext_t *context;
  struct zrbnode_t *root;
  struct zrbnode_block_t *blocks;
  struct zrbnode_t *heap;
  zcmp_t cmp;
  zdelete_t efree;
  unsigned int elemSize;
  unsigned int flags;
  unsigned int count;
  unsigned int blockSize;
};

#define zRBTreeCount(x)                ((x)->count)

Boolean zRBTreeInit( struct zcontext_t *cnt, struct zrbtree_t *rbt,
    unsigned int delta, unsigned int elemSize, zcmp_t cmp, zdelete_t efree);
void zRBTreeFree( struct zrbtree_t *rbt );

void *zRBTreeInsert( struct zrbtree_t *rbt, void *data);
void zRBTreeDeleteNode( struct zrbtree_t *rbt, void *data);
Boolean zRBTreeDelete( struct zrbtree_t *rbt, void *data);

void *zRBTreeFind( struct zrbtree_t *rbt, void *data);
void zRBTreeSort( struct zrbtree_t *rbt, zcmp_t cmp);

void *zRBTreeElem( struct zrbtree_t *rbt, unsigned int index);
unsigned int zRBTreeIndex( struct zrbtree_t *rbt, void *data);

void *zRBTreeNextNode( struct zrbtree_t *rbt, void *data);
void *zRBTreePrevNode( struct zrbtree_t *rbt, void *data);

/**************************************************************************/
/*                                                                        */
/*  Set collection                                                        */
/*                                                                        */
/**************************************************************************/

struct zsetcoll_t
{
  struct zcontext_t *context;
  unsigned char **blocks;
  unsigned int blockDelta;
  unsigned int elemSize;
  unsigned int count;
  unsigned int delta;
};

#define zSetCollectionEmpty(cl)        ((cl)->count == 0)
#define zSetCollectionCount(cl)        ((cl)->count)
#define _zSetCollectionElem(cl,nm) \
    (&(cl)->blocks[(nm)/(cl)->delta][((nm)%(cl)->delta)*(cl)->elemSize])

void zSetCollectionInit( struct zcontext_t *cnt, struct zsetcoll_t *sc,
    unsigned int elemSize, unsigned int delta, unsigned int blockDelta);
void zSetCollectionFree( struct zsetcoll_t *sc, zdelete_t efree);

void *zSetCollectionElem( struct zsetcoll_t *sc, unsigned int num);
void *zSetCollectionAdd( struct zsetcoll_t *sc, void *data);
void *zSetCollectionFind( struct zsetcoll_t *sc, const void *elem, zcmp_t cmp);

#ifdef __cplusplus
}
#endif

#endif
