/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __ZCODING_A
#define __ZCODING_A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* CRC32 */
const unsigned zint_t *zCodingGetCRCTable();
unsigned zint_t zCodingCRC32( unsigned zint_t crc32, const char *buf, unsigned int len);

/* BASE64 */
#define ZBASE64_ENCODE_LENGTH(x)       (((x) + 2) / 3 * 4)
#define ZBASE64_DECODE_LENGTH(x)       (((x) + 3) / 4 * 3)

extern const char * const zCodingBase64Alphabet;

int zCodingBase64Encode( char *dest, const char *src, int length);
int zCodingBase64Decode( char *dest, const char *src, int length);

#ifdef __cplusplus
}
#endif

#endif
