/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __ZCHARSET_A
#define __ZCHARSET_A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* ஢ */
#define ZCHARSET_UNKNOWN               -1

enum
{
  ZCHARSET_CYR_KOI,
  ZCHARSET_CYR_WIN,
  ZCHARSET_CYR_ALT,
  ZCHARSET_CYR_ISO,
  ZCHARSET_CYR_MAC,
  ZCHARSET_CYR_LAST,
  ZCHARSET_CYR_TRANS,
};

#define zCharsetValid(x)               ((x) >= 0 && (x) < ZCHARSET_CYR_LAST)

/* 室 ⮫쪮  楤 ४஢ 室 ⮢. */
#define arc_koi                        ZCHARSET_CYR_KOI
#define arc_win                        ZCHARSET_CYR_WIN
#define arc_alt                        ZCHARSET_CYR_ALT
#define arc_iso                        ZCHARSET_CYR_ISO
#define arc_mac                        ZCHARSET_CYR_MAC

#define ZCHARSET_NAME_OFFICIAL         0x0001u
#define ZCHARSET_NAME_SHORT            0x0002u
#define ZCHARSET_NAME_SHORTUP          0x0004u

int zCharsetType( const char *name );
const char *zCharsetName( int type, unsigned int flags);
int zCharsetCount( void );

int zCharsetByWord( const char *word, const char *pattern, int localCharset);

/* Global charset */
enum
{
  ZGCS_NONE = 0,     /* don't bother about ... */
  ZGCS_RU_START = 1,
  ZGCS_RU_ISO = ZGCS_RU_START,
  ZGCS_RU_KOI,
  ZGCS_RU_WIN,
  ZGCS_RU_ALT,
  ZGCS_RU_MAC,
  ZGCS_RU_LAST = ZGCS_RU_MAC,
};

int zToLocalCharset( int globalCharset );
int zToGlobalCharset( int localCharset );
Boolean zIsKnownCharset( int globalCharset );

/* ⠭ 쭮  㤠 ஢ */
#ifdef RUSSIAN_SUPPORT
void zSetRemoteCharset( struct zcontext_t *cnt, int inCharset, int outCharset);
void zSetRemoteStrictCharset( struct zcontext_t *cnt, int strictCharset);
#endif


/*  ४஢ */
struct ztranst_t
{
  char *text;
  int length;
};

ZEXT(char) koi2winTable[128];
ZEXT(char) win2koiTable[128];
ZEXT(char) koi2altTable[128];
ZEXT(char) alt2koiTable[128];
ZEXT(char) koi2isoTable[128];
ZEXT(char) iso2koiTable[128];
ZEXT(char) koi2scoTable[128];
ZEXT(char) sco2koiTable[128];
ZEXT(char) koi2macTable[128];
ZEXT(char) mac2koiTable[128];
ZEXT(char) win2altTable[128];
ZEXT(char) alt2winTable[128];
ZEXT(char) win2isoTable[128];
ZEXT(char) iso2winTable[128];
ZEXT(char) win2scoTable[128];
ZEXT(char) sco2winTable[128];
ZEXT(char) win2macTable[128];
ZEXT(char) mac2winTable[128];
ZEXT(char) alt2isoTable[128];
ZEXT(char) iso2altTable[128];
ZEXT(char) alt2scoTable[128];
ZEXT(char) sco2altTable[128];
ZEXT(char) alt2macTable[128];
ZEXT(char) mac2altTable[128];
ZEXT(char) iso2scoTable[128];
ZEXT(char) sco2isoTable[128];
ZEXT(char) iso2macTable[128];
ZEXT(char) mac2isoTable[128];
ZEXT(char) sco2macTable[128];
ZEXT(char) mac2scoTable[128];

ZEXT(struct ztranst_t) koi2transTable[128];
ZEXT(struct ztranst_t) win2transTable[128];
ZEXT(struct ztranst_t) alt2transTable[128];
ZEXT(struct ztranst_t) iso2transTable[128];
ZEXT(struct ztranst_t) sco2transTable[128];
ZEXT(struct ztranst_t) mac2transTable[128];

ZEXT(char *) koi2anyTables[ZCHARSET_CYR_LAST];
ZEXT(char *) any2koiTables[ZCHARSET_CYR_LAST];
ZEXT(char *) win2anyTables[ZCHARSET_CYR_LAST];
ZEXT(char *) any2winTables[ZCHARSET_CYR_LAST];
ZEXT(char *) alt2anyTables[ZCHARSET_CYR_LAST];
ZEXT(char *) any2altTables[ZCHARSET_CYR_LAST];
ZEXT(char *) iso2anyTables[ZCHARSET_CYR_LAST];
ZEXT(char *) any2isoTables[ZCHARSET_CYR_LAST];
ZEXT(char *) mac2anyTables[ZCHARSET_CYR_LAST];
ZEXT(char *) any2macTables[ZCHARSET_CYR_LAST];
ZEXT(char **) any2anyTables[ZCHARSET_CYR_LAST+1];
ZEXT(struct ztranst_t *) any2transTables[ZCHARSET_CYR_LAST+1];


/* ᭮ ⠡ ᨬ  ࠧ ஢ */
enum
{
  ZCYR_UNICODE = 0,
  ZCYR_KOI8_R,
  ZCYR_KOI8_U,
  ZCYR_WIN,
  ZCYR_ALT_R,
  ZCYR_ALT_U,
  ZCYR_ALT_RUSCII,
  ZCYR_ISO,
  ZCYR_ISO_SCO,
  ZCYR_MAC_R,
  ZCYR_MAC_U,
  ZCYR_TRANS,
  ZCYR_MAX,
  ZCYR_UNKNOWN
};

#define ZCYR_DEFAULT_SYMBOL        ' '
#define ZCYR_DEFAULT_TRANS_STRING  " "

struct zcyritem_t
{
  char *translit;
  unsigned int sym[ZCYR_MAX-1];
};

ZEXT(const struct zcyritem_t) zcyrTable[];

Boolean zCharsetRecodeTable( char *table, int fromCharset, int toCharset);
Boolean zCharsetTransTable( char **table, int charset);

int zCharsetCyritemType( const char *name, Boolean *isDefault);

#ifdef __cplusplus
}
#endif

#endif
