/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __ZCHARS_A
#define __ZCHARS_A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifdef RUSSIAN_SUPPORT
#define _UPPER_RUSSIANS                ""
#define _LOWER_RUSSIANS                ""
#define _VOVEL_RUSSIANS                ""
#define _CONSONANT_RUSSIANS            ""
#define _RUSSIAN_CAPITAL_IO            ''
#define _RUSSIAN_SMALL_IO              ''
#define _RUSSIAN_CAPITAL_E             ''
#define _RUSSIAN_SMALL_E               ''
#define _RUSSIAN_CAPITAL_SI            ''
#define _RUSSIAN_SMALL_SI              ''
#define _RUSSIAN_CAPITAL_U             ''
#define _RUSSIAN_SMALL_U               ''
#ifdef UKRAINIAN_SUPPORT
#define WIN_UKRAINIAN_CAPITAL_IE       0xaa
#define WIN_UKRAINIAN_SMALL_IE         0xba
#define WIN_UKRAINIAN_CAPITAL_BUI      0xb2
#define WIN_UKRAINIAN_SMALL_BUI        0xb3
#define WIN_UKRAINIAN_CAPITAL_YI       0xaf
#define WIN_UKRAINIAN_SMALL_YI         0xbf
#define WIN_UKRAINIAN_CAPITAL_SU       0xa1
#define WIN_UKRAINIAN_SMALL_SU         0xa2
#define WIN_UKRAINIAN_CAPITAL_UGHE     0xa5
#define WIN_UKRAINIAN_SMALL_UGHE       0xb4
#endif
#endif

#define CHAR_ENGLISH_UP                __ZINT(0x0001u)
#define CHAR_ENGLISH_DOWN              __ZINT(0x0002u)
#define CHAR_ENGLISH_VOWEL             __ZINT(0x0004u)
#define CHAR_ENGLISH_CONSONANT         __ZINT(0x0008u)
#define CHAR_RUSSIAN_UP                __ZINT(0x0010u)
#define CHAR_RUSSIAN_DOWN              __ZINT(0x0020u)
#define CHAR_RUSSIAN_VOWEL             __ZINT(0x0040u)
#define CHAR_RUSSIAN_CONSONANT         __ZINT(0x0080u)
#define CHAR_DIGIT                     __ZINT(0x0100u)
#define CHAR_XDIGIT                    __ZINT(0x0200u)
#define CHAR_SPACE                     __ZINT(0x0400u)
#define CHAR_INLINE_SPACE              __ZINT(0x0800u)
#define CHAR_CONTROL                   __ZINT(0x1000u)
#define CHAR_PUNCT                     __ZINT(0x2000u)
#define CHAR_SPECIAL                   __ZINT(0x4000u)
#define CHAR_URLSPEC                   __ZINT(0x8000u)
#define CHAR_USER_DEFINED              __ZINT(0x10000u)

#define CHAR_ENGLISH            (CHAR_ENGLISH_UP | CHAR_ENGLISH_DOWN)
#define CHAR_RUSSIAN            (CHAR_RUSSIAN_UP | CHAR_RUSSIAN_DOWN)
#define CHAR_ALPHA              CHAR_ENGLISH
#define CHAR_ALNUM              (CHAR_DIGIT | CHAR_ALPHA)
#define CHAR_UPPER              CHAR_ENGLISH_UP
#define CHAR_LOWER              CHAR_ENGLISH_DOWN
#define CHAR_VOWEL              (CHAR_ENGLISH_VOWEL | CHAR_RUSSIAN_VOWEL)
#define CHAR_CONSONANT          (CHAR_ENGLISH_CONSONANT | CHAR_RUSSIAN_CONSONANT)

ZEXT(unsigned zint_t) ztCharbitTable[256];

#define _testChar(x,y)          (ztCharbitTable[ (x) ] & (y))
#define _setCharbit(x,y)        (ztCharbitTable[ (x) ] |= (y))
#define _unsetCharbit(x,y)      (ztCharbitTable[ (x) ] &= ~(y))

#define testChar(x,y)           _testChar( (x) & 0xff, y)
#define setCharbit(x,y)         _setCharbit( (x) & 0xff, y)
#define unsetCharbit(x,y)       _unsetCharbit( (x) & 0xff, y)

#define _isSpace(x)             (ztCharbitTable[ (x) ] & CHAR_SPACE)
#define _isInlineSpace(x)       (ztCharbitTable[ (x) ] & CHAR_INLINE_SPACE)
#define _isAlpha(x)             (ztCharbitTable[ (x) ] & CHAR_ALPHA)
#define _isUpper(x)             (ztCharbitTable[ (x) ] & CHAR_UPPER)
#define _isLower(x)             (ztCharbitTable[ (x) ] & CHAR_LOWER)
#define _isAlnum(x)             (ztCharbitTable[ (x) ] & CHAR_ALNUM)
#define _isDigit(x)             (ztCharbitTable[ (x) ] & CHAR_DIGIT)
#define _isXDigit(x)            (ztCharbitTable[ (x) ] & CHAR_XDIGIT)
#define _isPunct(x)             (ztCharbitTable[ (x) ] & CHAR_PUNCT) 
#define _isSpecial(x)           (ztCharbitTable[ (x) ] & CHAR_SPECIAL)
#define _isURLSpecial(x)        (ztCharbitTable[ (x) ] & CHAR_URLSPEC)
#define _isRussian(x)           (ztCharbitTable[ (x) ] & CHAR_RUSSIAN)
#define _isVowel(x)             (ztCharbitTable[ (x) ] & CHAR_VOWEL) 
#define _isConsonant(x)         (ztCharbitTable[ (x) ] & CHAR_CONSONANT)

#define isSpace(x)              _isSpace( (x) & 0xff )
#define isInlineSpace(x)        _isInlineSpace( (x) & 0xff )
#define isAlpha(x)              _isAlpha( (x) & 0xff )
#define isUpper(x)              _isUpper( (x) & 0xff )
#define isLower(x)              _isLower( (x) & 0xff )
#define isAlnum(x)              _isAlnum( (x) & 0xff )
#define isDigit(x)              _isDigit( (x) & 0xff )
#define isXDigit(x)             _isXDigit( (x) & 0xff )
#define isPunct(x)              _isPunct( (x) & 0xff )
#define isSpecial(x)            _isSpecial( (x) & 0xff )
#define isURLSpecial(x)         _isURLSpecial( (x) & 0xff )
#define isRussian(x)            _isRussian( (x) & 0xff )
#define isVowel(x)              _isVowel( (x) & 0xff )
#define isConsonant(x)          _isConsonant( (x) & 0xff )

#define _isAscii(x)             (((x) & 0x80) == 0)
#define isAscii(x)              _isAscii(x)

ZEXT(unsigned char) ztLowerTable[256];
ZEXT(unsigned char) ztUpperTable[256];
#define _toLower(x)             ztLowerTable[(x)]
#define _toUpper(x)             ztUpperTable[(x)]
#define toLower(x)              _toLower( (x) & 0xff )
#define toUpper(x)              _toUpper( (x) & 0xff )

/* Cyryllic support */
#ifdef RUSSIAN_SUPPORT
ZEXT(unsigned char) ztSequenceTable[256];
ZEXT(unsigned char) ztFixupTable[256];

ZEXT(const char *) zsUpperRussians;
ZEXT(const char *) zsLowerRussians;
ZEXT(const char *) zsVowelRussians;
ZEXT(const char *) zsConsonantRussians;

void zInitRussians( void );
#endif

#ifdef __cplusplus
}
#endif

#endif
