/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __ZALLOC_A
#define __ZALLOC_A

#ifndef __ZDEFS_A
#include "zdefs.h"
#endif

#include <stdlib.h>

#ifdef __cplusplus
extern "C" {
#endif

#define ZNEW(cnt,x) (x *) zMalloc( cnt, sizeof( x ))
#define _ZFREE(cnt,x) if( (x) != NULL ) zFree( cnt, (x))
#define ZFREE(cnt,x); if( (x) != NULL ){ zFree( cnt, (x)); (x) = NULL; }

ZEXT(const char * const) zDummyString;

/* zMalloc, zRealloc & zFree */
#if defined( ZCHECK_SYSTEM_ALLOCATIONS )
ZAPI(void *) zchkMalloc( struct zcontext_t *cnt, size_t size,
    char *fileName, int lineNumber);
#define zMalloc(x,y) zchkMalloc( (x), (y), __FILE__, __LINE__)
ZAPI(void *) zchkRealloc( struct zcontext_t *cnt, void *ptr, size_t size,
    char *fileName, int lineNumber);
#define zRealloc(x,y,z) zchkRealloc( (x), (y), (z), __FILE__, __LINE__)
ZAPI(void) zchkFree( struct zcontext_t *cnt, const void *ptr,
    char *fileName, int lineNumber);
#define zFree(x,y) zchkFree( (x), (y), __FILE__, __LINE__)
#else
ZAPI(void *) zMalloc( struct zcontext_t *cnt, size_t size);
#define zchkMalloc(x,y,f,l) zMalloc( (x), (y))
ZAPI(void *) zRealloc( struct zcontext_t *cnt, void *ptr, size_t size);
#define zchkRealloc(x,y,z,f,l) zRealloc( (x), (y), (z))
ZAPI(void) zFree( struct zcontext_t *cnt, const void *ptr);
#define zchkFree(x,y,f,l) zFree( (x), (y))
#endif

/* zCalloc, zRecalloc */
#if defined( ZCHECK_SYSTEM_ALLOCATIONS )
void *zchkCalloc( struct zcontext_t *cnt, unsigned int nmemb, size_t size, Boolean zero,
    char *fileName, int lineNumber);
#define zCalloc(x,y,z,b) zchkCalloc( (x), (y), (z), (b), __FILE__, __LINE__)
void *zchkRecalloc( struct zcontext_t *cnt, void *ptr, unsigned int nmemb, size_t size,
    char *fileName, int lineNumber);
#define zRecalloc(x,y,z) zchkRecalloc( (x), (y), (z), __FILE__, __LINE__)
#else
void *zCalloc( struct zcontext_t *cnt, unsigned int nmemb, size_t size, Boolean zero);
#define zchkCalloc(x,y,z,b,f,l) zCalloc( (x), (y), (z), (b))
void *zRecalloc( struct zcontext_t *cnt, void *ptr, unsigned int nmemb, size_t size);
#define zchkRecalloc(x,y,z,f,l) zRecalloc( (x), (y), (z))
#endif

/* zStrdup, zMemdup */
#if defined( ZCHECK_SYSTEM_ALLOCATIONS )
ZAPI(char *) zchkStrdup( struct zcontext_t *cnt, const char *s,
    char *fileName, int lineNumber);
#define zStrdup(x,y) zchkStrdup( (x), (y), __FILE__, __LINE__)
ZAPI(char *) zchkStrndup( struct zcontext_t *cnt, const char *s, unsigned int length,
    char *fileName, int lineNumber);
#define zStrndup(x,y,z) zchkStrndup( (x), (y), (z), __FILE__, __LINE__)
ZAPI(void *) zchkMemdup( struct zcontext_t *cnt, const void *m, unsigned int length,
    char *fileName, int lineNumber);
#define zMemdup(x,y,z) zchkMemdup( (x), (y), (z), __FILE__, __LINE__)
#else
ZAPI(char *) zStrdup( struct zcontext_t *cnt, const char *s);
#define zchkStrdup(x,y,f,l) zStrdup( (x), (y))
ZAPI(char *) zStrndup( struct zcontext_t *cnt, const char *s, unsigned int length);
#define zchkStrndup(x,y,z,f,l) zStrndup( (x), (y), (z))
ZAPI(void *) zMemdup( struct zcontext_t *cnt, const void *m, unsigned int length);
#define zchkMemdup(x,y,z,f,l) zMemdup( (x), (y), (z))
#endif

/* zStrdupEx, zSubStrdup */
#if defined( ZCHECK_SYSTEM_ALLOCATIONS )
ZAPI(char *) zchkStrdupEx( struct zcontext_t *cnt, const char *string, const char *adds, unsigned int addsSize,
    char *fileName, int lineNumber);
#define zStrdupEx(x,y,z,s) zchkStrdupEx( (x), (y), (z), (s), __FILE__, __LINE__)
ZAPI(char *) zchkSubStrdup( struct zcontext_t *cnt, const char *begin, const char *end,
    char *fileName, int lineNumber);
#define zSubStrdup(x,y,z) zchkSubStrdup( (x), (y), (z), __FILE__, __LINE__)
#else
ZAPI(char *) zStrdupEx( struct zcontext_t *cnt, const char *string, const char *adds, unsigned int addsSize);
#define zchkStrdupEx(x,y,z,s,f,l) zStrdupEx( (x), (y), (z), (s))
ZAPI(char *) zSubStrdup( struct zcontext_t *cnt, const char *begin, const char *end);
#define zchkSubStdup(x,y,z,f,l) zSubStrdup( (x), (y), (z))
#endif

#ifdef __cplusplus
}
#endif

#endif
