/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstdio.h" /* <stdio.h> */
#include "_ptime.h" /* <time.h> */
#if defined( HAVE_GETTIMEOFDAY ) && defined( __MSVC__ )
#include "_pwin.h"
#endif

#include "zstdio.h"
#include "ztime.h"

ZFUN(Boolean) zInitTimeValue( struct ztimeval_t *t )
{
  t->type = ettUnknown;

#if defined( HAVE_GETTIMEOFDAY )
#ifdef __MSVC__
  {
    FILETIME fileTime;
    LONGLONG value;
    GetSystemTimeAsFileTime( &fileTime );
    value = (((LONGLONG) fileTime.dwHighDateTime) << 32);
    value |= ((LONGLONG) fileTime.dwLowDateTime);
    value /= 10;
    t->tv.tv_sec = (long) (value / __ZINT(1000000));
    t->tv.tv_usec = (long) (value % __ZINT(1000000));
  }
#else
  if( gettimeofday( &t->tv, NULL) < 0 ) return False;
#endif
  t->type = ettTimeValue;
#elif defined( HAVE_FTIME )
  ftime( &t->tv );
  t->type = ettTimeValue;
#else
  if( (t->tv = time( NULL )) == (time_t)(-1) ) return False;
  t->type = ettTime;
#endif

  return True;
}

ZFUN(Boolean) zSubTimeValue( struct ztimeval_t *t2, struct ztimeval_t *t1, int *psecs, int *pmsecs)
{
  if( t1->type == ettUnknown || t2->type == ettUnknown ) return False;

#if defined( HAVE_GETTIMEOFDAY )
  if( t2->tv.tv_sec < t1->tv.tv_sec ||
      (t2->tv.tv_sec == t1->tv.tv_sec && t2->tv.tv_usec < t1->tv.tv_usec) )
    return False;

  {
    long du;
    *psecs = (int) (t2->tv.tv_sec - t1->tv.tv_sec);
    if( t2->tv.tv_usec >= t1->tv.tv_usec )
      du = t2->tv.tv_usec - t1->tv.tv_usec;
    else
    {
      du = 1000000L + t2->tv.tv_usec - t1->tv.tv_usec;
      (*psecs)--;
    }
    *pmsecs = (int) (du / 1000);
    if( (int) (du % 1000) >= 500 ) (*pmsecs)++;
  }
#elif defined( HAVE_FTIME )
  if( t2->tv.time < t1->tv.time ||
      (t2->tv.time == t1->tv.time && t2->tv.millitm < t1->tv.millitm) )
    return False;
  *psecs = (int) (t2->tv.time - t1->tv.time);
  if( t2->tv.millitm >= t1->tv.millitm )
    *pmsecs = t2->tv.millitm - t1->tv.millitm;
  else
  {
    *pmsecs = 1000 + t2->tv.millitm - t1->tv.millitm;
    (*psecs)--;
  }
#else
  {
    double d = difftime( t2->tv, t1->tv);
    *pmsecs = 0;
    if( (*psecs = (int) d) < 0 ) return False;
  }
#endif

  return True;
}

#ifdef __MSVC__
#pragma warning( disable: 4100)
#else
#pragma warn -par
#endif

ZFUN(char *) zGetTimeValue( char *buf, int size, struct ztimeval_t *t2, struct ztimeval_t *t1)
{
  int secs, msecs;

  if( !zSubTimeValue( t2, t1, &secs, &msecs) )
    *buf = '\0';
  else if( secs >= 60 )
  {
    if( msecs >= 500 ) secs++;
    zsprintf( buf, size, "%d min %.2d sec", secs / 60, secs % 60);
  }
  else if( t2->type == ettTime )
  {
    if( secs == 0 )
      zsprintf( buf, size, "< 1 sec");
    else
      zsprintf( buf, size, "%d sec", secs);
  }
  else
  {
    if( secs == 0 && msecs == 0 )
      zsprintf( buf, size, "< 1 ms");
    else
      zsprintf( buf, size, "%d.%.3d sec", secs, msecs);
  }

  return buf;
}

#ifdef __MSVC__
#pragma warning( default: 4100)
#else
#pragma warn .par
#endif
