/*
    LIBZEX
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */

#include "zchars.h"
#include "ztime.h"


#define SKIP_CHAR(c); \
    if( *string != c ) goto er; \
    string++;

#define SKIP_SPACES(); \
    if( !isInlineSpace( *string ) ) goto er; \
    while( isInlineSpace( *string ) ) string++;

#define SKIP_MINUS(); \
    if( *string == '-' ) \
      string++;       \
    else if( isInlineSpace( *string ) ) \
      while( isInlineSpace( *string ) ) string++; \
    else              \
      goto er;

#define GET_YEAR();   \
    if( !isDigit( string[0] ) || !isDigit( string[1] ) ) goto er; \
    year = (string[0] - '0') * 10 + (string[1] - '0'); \
    string += 2;      \
    if( isDigit( string[0] ) && isDigit( string[1] ) ) \
    {                 \
      year *= 100;    \
      year += (string[0] - '0') * 10 + (string[1] - '0'); \
      string += 2;    \
    }                 \
    else if( *string == '\0' || isSpace( *string ) ) \
      year += (year <= 43) ? 2000 : 1900; \
    else              \
      goto er;        \
    if( year < 1980 || year > 2043 ) goto er; \
    year -= 1980;

#define GET_MONTH();  \
    if( !isDigit( *string ) ) goto er; \
    if( isDigit( string[1] ) ) \
    {                 \
      month = (string[0] - '0') * 10 + (string[1] - '0'); \
      string++;       \
    }                 \
    else              \
      month = (string[0] - '0'); \
    string++;         \
    if( month > 12 || month <= 0 ) goto er;

#define GET_DAY();    \
    if( !isDigit( *string ) ) goto er; \
    if( isDigit( string[1] ) ) \
    {                 \
      day = (string[0] - '0') * 10 + (string[1] - '0'); \
      string++;       \
    }                 \
    else              \
      day = (string[0] - '0'); \
    string++;         \
    if( day > 31 || day <= 0 ) goto er;

#define GET_HOUR();   \
    if( !isDigit( *string ) ) goto er; \
    if( isDigit( string[1] ) ) \
    {                 \
      hour = (string[0] - '0') * 10 + (string[1] - '0'); \
      string++;       \
    }                 \
    else              \
      hour = (string[0] - '0'); \
    string++;         \
    if( hour < 0 || hour >= 24 ) goto er;

#define GET_MINUTE(); \
    if( !isDigit( string[0] ) && !isDigit( string[1] ) ) goto er; \
    min = (string[0] - '0') * 10 + (string[1] - '0'); \
    if( min < 0 || min >= 60 ) goto er; \
    string++;         \
    string++;

#define GET_SECOND(); \
    if( !isDigit( string[0] ) && !isDigit( string[1] ) ) goto er; \
    sec = (string[0] - '0') * 10 + (string[1] - '0'); \
    if( sec < 0 || sec >= 60 ) goto er; \
    string++;         \
    string++;

#define GET_TIME();   \
        GET_HOUR();   \
        SKIP_CHAR(':'); \
        GET_MINUTE(); \
        SKIP_CHAR(':'); \
        GET_SECOND();

#if defined( RUSSIAN_SUPPORT ) && defined( UKRAINIAN_SUPPORT )
#define IS_MONTH_RUSSIAN_NAME() \
    ||                          \
    (zCheckFlags( flags, ztsRussianNames) && \
     (strncasecmp( string, zMonthRussianList[month], \
	len = strlen( zMonthRussianList[month] )) == 0 || \
      strncasecmp( string, zMonthUkrainianList[month], \
	len = strlen( zMonthUkrainianList[month] )) == 0 || \
      strncasecmp( string, zMonthAltRussianList[month], \
	len = strlen( zMonthAltRussianList[month] )) == 0 || \
      strncasecmp( string, zMonthAltUkrainianList[month], \
	len = strlen( zMonthAltUkrainianList[month] )) == 0 || \
      strncasecmp( string, zMonthShortRussianList[month], \
	len = strlen( zMonthShortRussianList[month] )) == 0 || \
      strncasecmp( string, zMonthShortUkrainianList[month], \
	len = strlen( zMonthShortUkrainianList[month] )) == 0))
#elif defined( RUSSIAN_SUPPORT )
#define IS_MONTH_RUSSIAN_NAME() \
    ||                          \
    (zCheckFlags( flags, ztsRussianNames) && \
     (strncasecmp( string, zMonthRussianList[month], \
	len = strlen( zMonthRussianList[month] )) == 0 || \
      strncasecmp( string, zMonthAltRussianList[month], \
        len = strlen( zMonthAltRussianList[month] )) == 0 || \
      strncasecmp( string, zMonthShortRussianList[month], \
        len = strlen( zMonthShortRussianList[month] )) == 0))
#else
#define IS_MONTH_RUSSIAN_NAME()
#endif

#define FOR_MONTH_NAME() \
    for( month = 0; month < 12; month++) \
      if( strncasecmp( string, zMonthEnglishList[month], \
            len = strlen( zMonthEnglishList[month] )) == 0 || \
          strncasecmp( string, zMonthShortEnglishList[month], \
            len = strlen( zMonthShortEnglishList[month] )) == 0 \
          IS_MONTH_RUSSIAN_NAME() )

#if defined( RUSSIAN_SUPPORT ) && defined( UKRAINIAN_SUPPORT )
#define IS_WEEKDAY_RUSSIAN_NAME() \
    ||                            \
    (zCheckFlags( flags, ztsRussianNames) && \
     (strncasecmp( string, zWeekdayRussianList[weekday], \
        len = strlen( zWeekdayRussianList[weekday] )) == 0 || \
      strncasecmp( string, zWeekdayUkrainianList[weekday], \
        len = strlen( zWeekdayUkrainianList[weekday] )) == 0 || \
      strncasecmp( string, zWeekdayAltShortRussianList[weekday], \
	len = strlen( zWeekdayAltShortRussianList[weekday] )) == 0 || \
      strncasecmp( string, zWeekdayAltShortUkrainianList[weekday], \
        len = strlen( zWeekdayAltShortUkrainianList[weekday] )) == 0 || \
      strncasecmp( string, zWeekdayShortRussianList[weekday], \
        len = strlen( zWeekdayShortRussianList[weekday] )) == 0 || \
      strncasecmp( string, zWeekdayShortUkrainianList[weekday], \
        len = strlen( zWeekdayShortUkrainianList[weekday] )) == 0))
#elif defined( RUSSIAN_SUPPORT )
#define IS_WEEKDAY_RUSSIAN_NAME() \
    ||                            \
    (zCheckFlags( flags, ztsRussianNames) && \
     (strncasecmp( string, zWeekdayRussianList[weekday], \
        len = strlen( zWeekdayRussianList[weekday] )) == 0 || \
      strncasecmp( string, zWeekdayAltShortRussianList[weekday], \
	len = strlen( zWeekdayAltShortRussianList[weekday] )) == 0 || \
      strncasecmp( string, zWeekdayShortRussianList[weekday], \
        len = strlen( zWeekdayShortRussianList[weekday] )) == 0))
#else
#define IS_WEEKDAY_RUSSIAN_NAME()
#endif

#define FOR_WEEKDAY_NAME() \
    for( weekday = 0; weekday < 7; weekday++) \
      if( strncasecmp( string, zWeekdayEnglishList[weekday], \
            len = strlen( zWeekdayEnglishList[weekday] )) == 0 || \
          strncasecmp( string, zWeekdayShortEnglishList[weekday], \
            len = strlen( zWeekdayShortEnglishList[weekday] )) == 0 \
          IS_WEEKDAY_RUSSIAN_NAME() )

#define GET_MONTH_NAME(); \
    FOR_MONTH_NAME() break; \
    month++;              \
    string += len;        \
    if( month > 12 ) goto er;


ZFUN(ztime_t) zTimeFromString( const char *string, char **rv, unsigned int flags)
{
  int year, month, day, hour, min, sec, weekday, len;

  while( isInlineSpace( *string ) ) string++;

  if( isDigit( *string ) )
  {
    /* ࠥ ᫥騩 ଠ: "[m]m.[d]d.[yy]yy[ [h]h:nn:ss]" */
    if( zCheckFlags( flags, ztsDayFirst) ){ GET_DAY(); }else{ GET_MONTH(); }
    SKIP_CHAR('.');
    if( zCheckFlags( flags, ztsDayFirst) ){ GET_MONTH(); }else{ GET_DAY(); }
    SKIP_CHAR('.');
    GET_YEAR();
    if( rv != NULL ) *rv = (char *) string;
    if( isInlineSpace( *string ) )
    {
      while( isInlineSpace( *string ) ) string++;
      if( isDigit( string[0] ) && (string[1] == ':' ||
	   (isDigit( string[1] ) && string[2] == ':')) )
      {
        GET_TIME();
        if( rv != NULL ) *rv = (char *) string;
      }
      else
        hour = min = sec = 0;
    }
    else
      hour = min = sec = 0;
  }
  else if( isAlpha( *string ) )
  {
    int status = 0;

    /* ஡㥬 ।,  祣 稭 ப... */
    /*  ? */
    FOR_MONTH_NAME()
    {
      status = 1;
      break;
    }

    /*   ? */
    if( status == 0 )
      FOR_WEEKDAY_NAME()
      {
        status = 2;
        break;
      }

    if( status == 0 )
      goto er;
    else if( status == 1 )
    {
      month++;
      string += len;
      SKIP_SPACES();

      /* ࠥ ᫥騩 ଠ: "Month [d]d [h]h:nn:ss [yy]yy" */
      GET_DAY();
      SKIP_SPACES();
      GET_TIME();
      SKIP_SPACES();
      GET_YEAR();
    }
    else
    {
      /*  稭 ࠧ ⠭⭮ ।⠢  */
      /* RFC 822:   Sun, 06 Nov 1994 08:49:37                    */
      /* RFC 850:   Sunday, 06-Nov-94 08:49:37                   */
      /* asctime(): Sun Nov  6 08:49:37 1994                     */
      string += len;
      if( *string == ',' )
      {
        string++;
        SKIP_SPACES();
        GET_DAY();
        SKIP_MINUS();
        GET_MONTH_NAME();
        SKIP_MINUS();
        GET_YEAR();
        SKIP_SPACES();
        GET_TIME();
      }
      else if( isInlineSpace( *string ) )
      {
        while( isInlineSpace( *string ) ) string++;
        GET_MONTH_NAME();
        SKIP_SPACES();
        GET_DAY();
        SKIP_SPACES();
        GET_TIME();
        SKIP_SPACES();
        GET_YEAR();
      }
      else
        goto er;
    }
  }
  else
  {
er: if( rv != NULL ) *rv = (char *) string;
    return 0;
  }

  if( rv != NULL ) *rv = (char *) string;
  return _ZTIME( year, month, day, hour, min, sec);
}
