/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */
#include "_ptime.h" /* <time.h> */

#include "zchars.h"
#include "ztime.h"

/****************************************************************************
   । ᫥騥 ଠ:
     %% - ᨬ %
     %a -   
     %A - 祭   
     %b -  
     %B - 祭  
     %c -  ।⠢   ६
     %C - 祭 ।⠢   ६
     %d -      (01...31)
     %D -     (1...31)
     %e -  ।⠢ 
     %E - 祭 ।⠢ 
     %h -    (01-23)
     %H -   (1-23)
     %m -      (01-12)
     %M -     (1-12)
     %n -    (00-59)
     %N -   (0-59)
     %s -   ᥪ㭤 (00-59)
     %S -  ᥪ㭤 (0-59)
     %x -  ।⠢ ६
     %X - 祭 ।⠢ ६
     %y -    (70-38)
     %Y -    (1970-2038)

    ଠ 䫠:
     _  -  뢮 ப  ᨬ     ॣ
     ^  -  뢮 ப  ᨬ    孥 ॣ
     #  - ᯮ짮 ୠ⨢   ।⠢
     sp -  ⪨ ᫮ ଠ⮢ (MDHNS) ⠢ ⥫
          ஡, ᫨ 뢮 ⮫쪮  

  ਬ:
  asctime()  <=>  "%A %B % D %h:%n:%s %Y"
  RFC822     <=>  "%A, %d %B %Y %h:%n:%s"
  RFC850     <=>  "%a, %d-%B-%y %h:%n:%s"
****************************************************************************/

#define tsfToLower                     0x0001u
#define tsfToUpper                     0x0002u
#define tsfAlt                         0x0004u
#define tsfSpace                       0x0008u
#define tsfFormat_C                    0x0010u
#define tsfFormat_c                    0x0020u
#define tsfFormat_E                    0x0040u
#define tsfFormat_e                    0x0080u
#define tsfFormat_X                    0x0100u
#define tsfFormat_x                    0x0200u

#define STRING(ts,sn,altStrings) \
    ((strings != NULL && strings[(ts)] != NULL && strings[(ts)][(sn)] != NULL) ? \
     strings[(ts)][(sn)] : (altStrings[(sn)] != NULL ? altStrings[(sn)] : ""))

#define FORMAT(fn) \
    STRING( ztsTimeFormats, (fn), zTimeEnglishFormats)

#define PUT0(x) \
    if( (x) >= 10 ) \
      line[len++] = (((x) / 10) % 10) + '0'; \
    else if( zCheckFlags( fmtFlags, tsfSpace) ) \
      line[len++] = ' '; \
    line[len++] = ((x) % 10) + '0'

#define PUT1(x) \
    line[len++] = (x)

#define PUT2(x) \
    line[len++] = (((x) / 10) % 10) + '0'; \
    line[len++] = ((x) % 10) + '0'

#define PUT4(x) \
    line[len++] = (((x) / 1000) % 10) + '0'; \
    line[len++] = (((x) / 100) % 10) + '0'; \
    line[len++] = (((x) / 10) % 10) + '0'; \
    line[len++] = ((x) % 10) + '0'

#define PUTS(s) \
    do          \
    {           \
      {         \
	register const char *string = (s); \
        for( len = 0; len < sizeof(line) && string[len] != '\0'; len++) line[len] = string[len]; \
      }         \
      {         \
	register int i; \
	if( zCheckFlags( fmtFlags, tsfToLower) ) \
	  for( i = 0; i < sizeof(line); i++) \
	    line[i] = toLower( line[i] ); \
	else if( zCheckFlags( fmtFlags, tsfToUpper) ) \
	  for( i = 0; i < sizeof(line); i++) \
	    line[i] = toUpper( line[i] ); \
      }         \
    } while( 0 )

#define PRINT_STRING(s,l); \
    if( success && (l) > 0 ) \
    {                      \
      register const char *string = (s); \
      register int n = (l), i; \
                           \
      if( (*pleft) > 0 ) for( i = 0; i < n; i++) \
      {                    \
	if( --(*pleft) <= 0 )  \
        {                  \
	  success = False; \
          break;           \
        }                  \
        *buf ++ = string[i]; \
      }                    \
                           \
      *buf = '\0';         \
    }

static char *formatString( char *buf, int *pleft, const char *fmt,
    struct tm *tm, const char ***strings, unsigned int flags)
{
  const char *last, *p;
  int len;
  Boolean success = True, isFormat = False;
  unsigned int fmtFlags = flags;
  int year, month, weekday;

  if( (*pleft) <= 1 )
  {
    if( (*pleft) > 0 ) *buf = '\0';
    return 0;
  }

  if( (month = tm->tm_mon + 1) == 0 ) month = 1; else if( month > 12 ) month = 12;
  year = tm->tm_year + 1900;
  if( (weekday = tm->tm_wday) < 0 ) weekday = 0; else if( weekday > 6 ) weekday = 6;

  for( last = fmt; success && *fmt != '\0'; fmt++)
    if( isFormat )
    {
      char line[64];

      switch( *fmt )
      {
	case 'A':
          if( zCheckFlags( fmtFlags, tsfAlt) )
            PUTS( STRING( ztsWeekdayAltShortList, weekday, zWeekdayShortEnglishList) );
          else
            PUTS( STRING( ztsWeekdayShortList, weekday, zWeekdayShortEnglishList) );
          break;
        case 'a':
          if( zCheckFlags( fmtFlags, tsfAlt) )
            PUTS( STRING( ztsWeekdayAltList, weekday, zWeekdayEnglishList) );
          else
            PUTS( STRING( ztsWeekdayList, weekday, zWeekdayEnglishList) );
          break;
	case 'B':
          if( zCheckFlags( fmtFlags, tsfAlt) )
            PUTS( STRING( ztsMonthAltShortList, month-1, zMonthShortEnglishList) );
          else
            PUTS( STRING( ztsMonthShortList, month-1, zMonthShortEnglishList) );
          break;
        case 'b':
          if( zCheckFlags( fmtFlags, tsfAlt) )
            PUTS( STRING( ztsMonthAltList, month-1, zMonthAltEnglishList) );
          else
            PUTS( STRING( ztsMonthList, month-1, zMonthEnglishList) );
          break;
        case 'C':
          if( zCheckFlags( fmtFlags, tsfFormat_C) ) goto of;
          buf = formatString( buf, pleft, FORMAT( zCheckFlags( fmtFlags, tsfAlt) ?
                  ztsDateTimeAltShortFormat : ztsDateTimeShortFormat ), tm,
                  strings, fmtFlags | tsfFormat_C);
          success = (Boolean) (*pleft > 0);
          break;
	case 'c':
          if( zCheckFlags( fmtFlags, tsfFormat_c) ) goto of;
          buf = formatString( buf, pleft, FORMAT( zCheckFlags( fmtFlags, tsfAlt) ?
                  ztsDateTimeAltFormat : ztsDateTimeFormat ), tm,
                  strings, fmtFlags | tsfFormat_c);
          success = (Boolean) (*pleft > 0);
          break;
        case 'D':
          PUT0( tm->tm_mday );
          break;
        case 'd':
          PUT2( tm->tm_mday );
          break;
	case 'E':
          if( zCheckFlags( fmtFlags, tsfFormat_E) ) goto of;
          buf = formatString( buf, pleft, FORMAT( zCheckFlags( fmtFlags, tsfAlt) ?
                  ztsDateAltShortFormat : ztsDateShortFormat ), tm,
                  strings, fmtFlags | tsfFormat_E);
	  success = (Boolean) (*pleft > 0);
	  break;
        case 'e':
          if( zCheckFlags( fmtFlags, tsfFormat_e) ) goto of;
          buf = formatString( buf, pleft, FORMAT( zCheckFlags( fmtFlags, tsfAlt) ?
                  ztsDateAltFormat : ztsDateFormat ), tm,
                  strings, fmtFlags | tsfFormat_e);
          success = (Boolean) (*pleft > 0);
          break;
        case 'H':
          PUT0( tm->tm_hour );
          break;
	case 'h':
          PUT2( tm->tm_hour );
          break;
        case 'M':
          PUT0( month );
          break;
        case 'm':
          PUT2( month );
          break;
        case 'N':
          PUT0( tm->tm_min );
          break;
        case 'n':
	  PUT2( tm->tm_min );
          break;
        case 'S':
          PUT2( tm->tm_sec );
          break;
        case 's':
          PUT2( tm->tm_sec );
          break;
        case 'X':
          if( zCheckFlags( fmtFlags, tsfFormat_X) ) goto of;
          buf = formatString( buf, pleft, FORMAT( zCheckFlags( fmtFlags, tsfAlt) ?
                  ztsTimeAltShortFormat : ztsTimeShortFormat ),
                  tm, strings, fmtFlags | tsfFormat_X);
	  success = (Boolean) (*pleft > 0);
	  break;
	case 'x':
          if( zCheckFlags( fmtFlags, tsfFormat_x) ) goto of;
          buf = formatString( buf, pleft, FORMAT( zCheckFlags( fmtFlags, tsfAlt) ?
                  ztsTimeAltFormat : ztsTimeFormat ), tm,
                  strings, fmtFlags | tsfFormat_x);
          success = (Boolean) (*pleft > 0);
          break;
	case 'Y':
          PUT4( year );
          break;
        case 'y':
          PUT2( year );
          break;
        case 'Z':
        case 'z':
#if defined( HAVE_TM_ZONE )
          p = tm->tm_zone;
#elif defined( HAVE_TZNAME )
          tzset();
          p = (tm->tm_isdst > 0) ? tzname[1] : tzname[0];
#else
          p = "???";
#endif
          /* if( p != NULL) */ PUTS( p );
          break;
        case '#':
          zSetFlags( fmtFlags, tsfAlt);
          continue;
        case ' ':
          zSetFlags( fmtFlags, tsfSpace);
          continue;
        case '^':
          zSetFlags( fmtFlags, tsfToUpper);
	  continue;
        case '_':
          zSetFlags( fmtFlags, tsfToLower);
          continue;
        default:
of:       isFormat = False;
          if( *fmt == '%' ) goto nf;
          continue;
      }

      PRINT_STRING( line, len);
      isFormat = False;
      last = &fmt[1];
    }
    else if( *fmt == '%' )
    {
nf:   if( fmt[1] == '%' )
      {
        fmt++;
        if( fmt != last ) PRINT_STRING( last, (int) (fmt - last));
        last = &fmt[1];
      }
      else
      {
        if( fmt != last ) PRINT_STRING( last, (int) (fmt - last));
        last = fmt;
	isFormat = True;
	fmtFlags = flags;
        len = 0;
      }
    }

  if( success && fmt != last ) PRINT_STRING( last, (int) (fmt - last));
  return buf;
}

ZFUN(int) zTimeString( char *buf, int size, const char *fmt, struct tm *tm, const char ***strings)
{
  int left = size;

  if( size <= 1 )
  {
    if( size > 0 ) *buf = '\0';
    return 0;
  }

  (void) formatString( buf, &left, (fmt == NULL) ? "%c" : fmt, tm, strings, 0);
  return (left > 0) ? (size - left) : 0;
}

ZFUN(char *) zTimeFormat( char *buf, int size, const char *fmt, struct tm *tm, const char ***strings)
{
  int left = size;

  if( size <= 1 )
  {
    if( size > 0 ) *buf = '\0';
    return 0;
  }

  (void) formatString( buf, &left, (fmt == NULL) ? "%b %d %h:%n:%s %Y" : fmt, tm, strings, 0);
  return buf;
}
