/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */

#include "ztime.h"

/***************************************************************************/
/*                                                                         */
/*  Names                                                                  */
/*                                                                         */
/***************************************************************************/

ZDEF(const char *) zMonthEnglishList[13] =
{
  "January",
  "February",
  "March",
  "April",
  "May",
  "June",
  "July",
  "August",
  "September",
  "October",
  "November",
  "December",
  NULL
};

ZDEF(const char *) zMonthAltEnglishList[13] =
{
  "January,",
  "February,",
  "March,",
  "April,",
  "May,",
  "June,",
  "July,",
  "August,",
  "September,",
  "October,",
  "November,",
  "December,",
  NULL
};

ZDEF(const char *) zMonthShortEnglishList[13] =
{
  "Jan",
  "Feb",
  "Mar",
  "Apr",
  "May",
  "Jun",
  "Jul",
  "Aug",
  "Sep",
  "Oct",
  "Nov",
  "Dec",
  NULL
};

ZDEF(const char *) zWeekdayEnglishList[8] =
{
  "Sunday",
  "Monday",
  "Tuesday",
  "Wednesday",
  "Thursday",
  "Friday",
  "Saturday",
  NULL
};

ZDEF(const char *) zWeekdayShortEnglishList[8] =
{
  "Sun",
  "Mon",
  "Tue",
  "Wed",
  "Thu",
  "Fri",
  "Sat",
  NULL
};

ZDEF(const char *) zTimeEnglishFormats[ztsLastFormat+1] =
{
  "%m.%d.%Y",
  "%d %#b %Y",
  "%M.%d.%y",
  "%d %#B %Y",
  "%h:%n:%s",
  "%h:%n:%s",
  "%H:%n:%s",
  "%H:%n:%s",
  "%a %b %d %x %Y",
  "%a %b %d %x %Y",
  "%e %x",
  "%e %x",
  NULL
};

ZDEF(const char *) zTimeEnglishPeriods[ztsLastPeriod+1] =
{
  "For",
  "For",
  "from",
  "to",
  NULL
};

ZDEF(const char **) zTimeEnglishStrings[ztsLastStrings+1] =
{
  zMonthEnglishList,
  zMonthAltEnglishList,
  zMonthShortEnglishList,
  zMonthShortEnglishList,
  zWeekdayEnglishList,
  zWeekdayEnglishList,
  zWeekdayShortEnglishList,
  zWeekdayShortEnglishList,
  zTimeEnglishFormats,
  zTimeEnglishPeriods,
  NULL
};

#if defined( RUSSIAN_SUPPORT )
ZDEF(const char *) zMonthRussianList[13] =
{
  "",
  "ࠫ",
  "",
  "५",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  NULL
};

ZDEF(const char *) zMonthAltRussianList[13] =
{
  "",
  "ࠫ",
  "",
  "५",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  NULL
};

ZDEF(const char *) zMonthShortRussianList[13] =
{
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  NULL
};

ZDEF(const char *) zWeekdayRussianList[8] =
{
  "ᥭ",
  "쭨",
  "୨",
  "।",
  "⢥",
  "⭨",
  "㡡",
  NULL
};

ZDEF(const char *) zWeekdayShortRussianList[8] =
{
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  NULL
};

ZDEF(const char *) zWeekdayAltShortRussianList[8] =
{
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  NULL
};

ZDEF(const char *) zTimeRussianFormats[ztsLastFormat+1] =
{
  "%d.%m.%Y",
  "%d %#b %Y",
  "%D.%M.%y",
  "%d %#B %Y",
  "%h:%n:%s",
  "%h:%n:%s",
  "%H:%n:%s",
  "%H:%n:%s",
  "%a %b %d %x %Y",
  "%a %b %d %x %Y",
  "%e %x",
  "%e %x",
  NULL
};

ZDEF(const char *) zTimeRussianPeriods[ztsLastPeriod+1] =
{
  "",
  " ਮ",
  "",
  "",
  NULL
};

ZDEF(const char **) zTimeRussianStrings[ztsLastStrings+1] =
{
  zMonthRussianList,
  zMonthAltRussianList,
  zMonthShortRussianList,
  zMonthShortRussianList,
  zWeekdayRussianList,
  zWeekdayRussianList,
  zWeekdayShortRussianList,
  zWeekdayAltShortRussianList,
  zTimeRussianFormats,
  zTimeRussianPeriods,
  NULL
};
#endif

#if defined( RUSSIAN_SUPPORT ) && defined( UKRAINIAN_SUPPORT )
ZDEF(const char *) zMonthUkrainianList[13] =
{
  "祭",
  "⨩",
  "१",
  "⥭",
  "ࠢ",
  "ࢥ",
  "",
  "௥",
  "ᥭ",
  "⥭",
  "⮯",
  "㤥",
  NULL
};

ZDEF(const char *) zMonthAltUkrainianList[13] =
{
  "",
  "⮣",
  "१",
  "",
  "ࠢ",
  "ࢭ",
  "",
  "௭",
  "",
  "",
  "⮯",
  "㤭",
  NULL
};

ZDEF(const char *) zMonthShortUkrainianList[13] =
{
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  NULL
};

ZDEF(const char *) zWeekdayUkrainianList[8] =
{
  "",
  "",
  "ப",
  "।",
  "⢥",
  "'⭨",
  "㡮",
  NULL
};

ZDEF(const char *) zWeekdayShortUkrainianList[8] =
{
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  NULL
};

ZDEF(const char *) zWeekdayAltShortUkrainianList[8] =
{
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  NULL
};

/* XXX: 㦥 ॠ ॢ  ࠨ᪨ */
ZDEF(const char *) zTimeUkrainianPeriods[ztsLastPeriod+1] =
{
  "",
  " ਮ",
  "",
  "",
  NULL
};

ZDEF(const char *) zTimeUkrainianFormats[ztsLastFormat+1] =
{
  "%d.%m.%Y",
  "%d %#b %Y",
  "%D.%M.%y",
  "%d %#B %Y",
  "%h:%n:%s",
  "%h:%n:%s",
  "%H:%n:%s",
  "%H:%n:%s",
  "%a %b %d %x %Y",
  "%a %b %d %x %Y",
  "%e %x",
  "%e %x",
  NULL
};

ZDEF(const char **) zTimeUkrainianStrings[ztsLastStrings+1] =
{
  zMonthUkrainianList,
  zMonthAltUkrainianList,
  zMonthShortUkrainianList,
  zMonthShortUkrainianList,
  zWeekdayUkrainianList,
  zWeekdayUkrainianList,
  zWeekdayShortUkrainianList,
  zWeekdayAltShortUkrainianList,
  zTimeUkrainianFormats,
  zTimeUkrainianPeriods,
  NULL
};
#endif

/***************************************************************************/
/*                                                                         */
/*  Days                                                                   */
/*                                                                         */
/***************************************************************************/

ZDEF(const int) zTimeMonthDays[ZTIME_MONT_PER_YEAR+1] =
{
  31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, -1
};

ZDEF(const int) zTimeLeapDays[ZTIME_MONT_PER_YEAR+1] =
{
  31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, -1
};
