/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "zchars.h"
#include "zstring.h"

int zUnescapeString( char *string, Boolean spec)
{
  register char *in, *out;
  register Boolean escaped = False;
  register length = 0;

  if( *string == '\0' ) return 0;

  for( in = out = string; *in != '\0'; in++)
    if( escaped )
    {
      escaped = False;
      if( spec )
        switch( *in )
        {
          case 'n':
	    *out ++ = '\n';
	    break;
	  case 't':
	    *out ++ = '\t';
	    break;
	  case 'r':
	    *out ++ = '\r';
	    break;
          case 'b':
            *out ++ = '\b';
	    break;
	  default:
	    if( isDigit( in[0] ) && isDigit( in[1] ) && isDigit( in[2] ) &&
                in[0] < '4' && in[1] < '8' && in[2] < '8' )
            {
              *out ++ = (char) (((((in[0] - '0') << 3) | (in[1] - '0')) << 3) | (in[2] - '0'));
              in += 2;
            }
	    else if( in[0] == 'x' && isXDigit( in[1] ) && isXDigit( in[2] ) )
            {
              int n1 = _isDigit( in[1] ) ? (in[1] - '0') : (_toLower( in[1] ) - 'a' + 10);
              int n2 = _isDigit( in[2] ) ? (in[2] - '0') : (_toLower( in[2] ) - 'a' + 10);
	      *out ++ = (char) ((n1 << 4) | n2);
              in += 2;
            }
            else
              *out ++ = *in;
        }
      else
        *out ++ = *in;
      length++;
    }
    else if( *in == '\\' )
      escaped = True;
    else
    {
      *out ++ = *in;
      length++;
    }

  if( escaped )
  {
    *out ++ = '\\';
    length++;
  }

  *out = '\0';
  return length;
}
