/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "zchars.h"
#include "zstring.h"

char *zCompressString( char *string, Boolean all)
{
  register Boolean wasSpace = True;
  register int c;
  register char *in, *out;

  if( *string == '\0' ) return string;

  if( all )
    for( in = out = string; (c = *(unsigned char *) in) != '\0'; in++)
      if( _isSpace( c ) )
      {
        if( !wasSpace ) *out ++ = ' ';
        wasSpace = True;
      }
      else
      {
        *out ++ = (char) c;
        wasSpace = False;
      }
  else
    for( in = out = string; (c = *in) != '\0'; in++)
    {
      if( c != ' ' || !wasSpace ) *out ++ = (char) c;
      wasSpace = (c == ' ') ? True : False;
    }

  if( out != string && *(out-1) == ' ' ) out--;
  *out = '\0';

  return string;
}
