/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */

#include "zchars.h"
#include "zstring.h"

char *zstrcasestr( const char *string, const char *pattern)
{
  register const char *s, *p;
  register char pchar;

  if( (pchar = toLower( *pattern )) == '\0' ) return NULL;

  for( ; *string != '\0'; string++)
    if( toLower( *string ) == pchar )
      for( s = string+1, p = pattern+1; ; s++, p++)
      {
	if( *p == '\0' ) return (char *) string;
        if( *s == '\0' ) return NULL;
	if( toLower( *p ) != toLower( *s ) ) break;
      }

  return NULL;
}

char *zmemmem( const char *mem, int memlen, const char *pat, int patlen)
{
  register int i, j, l = memlen - patlen + 1;
  register const char *m = mem, *p = pat;

  for( i = 0; i < l; i++)
    if( m[i] == p[0] )
    {
      for( j = 1; j < patlen; j++)
        if( m[i+j] != p[j] ) break;
      if( j == patlen ) return (char *) &mem[i];
    }

  return NULL;
}

char *zmemcasemem( const char *mem, int memlen, const char *pat, int patlen)
{
  register int i, j, l = memlen - patlen + 1;
  register const unsigned char *m = (const unsigned char *) mem,
			       *p = (const unsigned char *) pat;
  unsigned char pchar = _toLower( p[0] );

  for( i = 0; i < l; i++)
    if( m[i] == pchar )
    {
      for( j = 1; j < patlen; j++)
        if( _toLower( m[i+j] ) != _toLower( p[j] ) ) break;
      if( j == patlen ) return (char *) &mem[i];
    }

  return NULL;
}

int zstrcasecmp( const char *str1, const char *str2)
{
  register int c;
  register const unsigned char *s1 = (const unsigned char *) str1,
                               *s2 = (const unsigned char *) str2;

  for( ; (c = *s1) != '\0'; s1++, s2++)
    if( _toLower( c ) != _toLower( *s2 ) )
      return (_toLower( c ) - _toLower( *s2 ));

  return *s2 == '\0' ? 0 : -1;
}

int zmemcasecmp( const char *mem1, const char *mem2, int length)
{
  register int i, l = length;
  register const unsigned char *m1 = (const unsigned char *) mem1,
			       *m2 = (const unsigned char *) mem2;

  if( l > 0 )
    for( i = 0; i < l; i++)
      if( _toLower( m1[i] ) != _toLower( m2[i] ) )
        return (_toLower( m1[i] ) - _toLower( m2[i] ));

  return 0;
}
