/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */

#include "zchars.h"
#include "zstring.h"

char *zNextWord( char *line, Boolean *wasError, char **pnext)
{
  Boolean quoted, escaped;
  char *ptr;

  if( wasError != NULL ) *wasError = False;

  if( line != NULL )
  {
    while( isSpace( *line ) ) line++;
    if( *line == '\0' ) return *pnext = NULL;
    *pnext = line;
  }
  else
  {
    if( *pnext == NULL ) return NULL;
    line = *pnext;
  }

  if( *line == '\"' )
  {
    quoted = True;
    line++;
  }
  else
    quoted = False;

  for( escaped = False, ptr = line; *ptr != '\0'; ptr++)
    if( escaped )
      escaped = False;
    else if( *ptr == '\\' )
      escaped = True;
    else if( quoted )
    {
      if( *ptr == '\"' )
      {
        quoted = False;
        break;
      }
    }
    else if( isSpace( *ptr ) )
      break;

  if( quoted )
  {
    if( wasError != NULL ) *wasError = True;
    return *pnext = NULL;
  }

  if( *ptr != '\0' )
  {
    *ptr ++ = '\0';
    while( isSpace( *ptr ) ) ptr++;
  }
  *pnext = (*ptr == '\0') ? NULL : ptr;

  return line;
}
