/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */

#include "zchars.h"
#include "zstring.h"

char *zNextToken( char *line, const char *terminators, char **pnext)
{
  char *ptr;

  if( *terminators == '\0' ) return *pnext;

  if( line != NULL )
  {
    while( *line != '\0' && isSpace( *line ) && strchr( terminators, *line) != NULL ) line++;
    if( *line == '\0' ) return *pnext = NULL;
    *pnext = line;
  }
  else
  {
    if( *pnext == NULL ) return NULL;
    line = *pnext;
  }

  for( ptr = *pnext; *ptr != '\0' && strchr( terminators, *ptr) == NULL; ptr++) continue;
  if( *ptr != '\0' )
  {
    *ptr ++ = '\0';
    while( *ptr != '\0' && isSpace( *ptr ) && strchr( terminators, *ptr) != NULL ) ptr++;
  }
  *pnext = (*ptr == '\0') ? NULL : ptr;

  return *line == '\0' ? NULL : line;
}
