/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */
#include <stdlib.h>

#include "zchars.h"
#include "zstdlib.h"

#define MAX_POWER             38

Boolean zDoubleValue( const char *string, char **rest, double *value)
{
  const char *copy = string;
  double a = 0.0;
  Boolean sign = True, success = False;

/* ࠡ뢠  */
  if( *string == '+' || *string == '-' )
  {
    sign = (Boolean) (*string == '+');
    string++;
  }

/*   ᫠ */
  while( *string != '\0' && isDigit( *string ) )
  {
    a *= 10;
    a += (double) (*string - '0');
    string++;
    success = True;
  }

/* ஡  ᫠ */
  if( *string == '.' )
  {
    double power = 10.0;
    string++;
    while( *string != '\0' && isDigit( *string ) )
    {
      a += ((double) (*string - '0')) / power;
      power *= 10.0;
      string++;
      success = True;
    }
  }

/* ⥯ */
  if( success && toLower( string[0] ) == 'e' &&
      ((isDigit( string[1] ) && string[1] != '0') ||
       ((string[1] == '+' || string[1] == '-') &&
        (isDigit( string[2] ) && string[2] != '0'))) )
  {
    Boolean powerSign = True;
    int powerValue, i;
    double power;
    char *rest;

    string++;

    if( *string == '+' || *string == '-' )
    {
      powerSign = (Boolean) (*string == '+');
      string++;
    }

    if( (powerValue = (int) strtol( string, &rest, 10)) <= 0 )
      success = False;
    else if( powerValue > MAX_POWER )
    {
      if( !powerSign )
      {
        a = 0.0;
        sign = True;
      }
      else
        success = False;
    }
    else
    {
      for( i = 0, power = 1.0; i < powerValue; i++) power *= 10.0;
      if( powerSign ) a *= power; else a /= power;
    }
  }

/*  ᫠ */
  if( !sign ) a = -a;

  if( rest != NULL ) *rest = success ? (char *) string : (char *) copy;
  *value = a;
  return success;
}
