/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


/* #define TEST */

#include "zdefs.h"
#ifdef TEST
#include "_pstdio.h" /* <stdio.h> */
#include <stdlib.h>
#endif
#include "_pstring.h" /* <string.h> */

#include "zchars.h"
#include "zstdlib.h"
#ifdef TEST
#include "chars2.c"
#include "chars4.c"
#include "chars6.c"
#endif

#define getSpecialChar(c); \
    switch( c )            \
    {                      \
      case 't': c = '\t'; break; \
      case 'n': c = '\n'; break; \
      case 'r': c = '\r'; break; \
    }

#define patternChar(e,s,ec); \
    for( escaped = False, e = NULL; (c = *s) != '\0'; s++) \
      if( c == '\\' && !escaped && s[1] != '\0' ) \
	escaped = True;      \
      else                   \
      {                      \
	if( c == ec && !escaped ){ e = s; break; } \
        escaped = False;     \
      }

const unsigned char *zCharMatch( unsigned int ch, const unsigned char *cstr,
    unsigned int flags)
{
  unsigned char endchar;
  const unsigned char *end;
  const unsigned char *s;
  Boolean reverse = False, escaped;
  register unsigned int c;

  switch( *cstr )
  {
    case spcSingleOpen:
      endchar = spcSingleClose;
      break;
    case spcMultipleOpen:
      endchar = spcMultipleClose;
      break;
    default:
      return NULL;
  }

  cstr++;
  if( cstr[0] == '^' )
  {
    reverse = True;
    cstr++;
  }

  s = (*cstr == endchar) ? cstr+1 : cstr;
  patternChar( end, s, endchar);
  if( end == NULL ) return NULL;
  if( ch == '\0' ) return ++end;

  ch &= 0xffu;
  if( zCheckFlags( flags, smfBraCaseIndep) ) ch = _toLower( ch );

  for( s = cstr; ; )
  {
    if( (c = *s) == '\\' /* XXX && s+1 < end */ )
    {
      c = *(++s);
      getSpecialChar( c );
    }

    if( zCheckFlags( flags, smfBraCaseIndep) ) c = _toLower( c );

    if( s[1] == '-' && s+2 < end )
    {
      unsigned int endc;
      s += 2;
      if( (endc = *s) == '\\' )
      {
        endc = *(++s);
        getSpecialChar( endc );
      }
      if( zCheckFlags( flags, smfBraCaseIndep) ) endc = _toLower( endc );
#ifdef RUSSIAN_SUPPORT
      if( zCheckFlags( flags, smfUseSequenceTable) )
      {
	if( ztSequenceTable[ch] >= ztSequenceTable[c] &&
	    ztSequenceTable[ch] <= ztSequenceTable[endc] )
          return reverse ? NULL : ++end;
      }
      else
#endif
	if( ch >= c && ch <= endc ) return reverse ? NULL : ++end;
    }
    else
      if( ch == c ) return reverse ? NULL : ++end;

    if( ++s >= end ) return reverse ? ++end : NULL;
  }
}

Boolean zStringMatch( const char *string, const char *pattern, unsigned int flags)
{
  const unsigned char *p, *r, *s = (const unsigned char *) string;
  unsigned int c;
  Boolean escaped = False;

  for( p = (unsigned char *) pattern; *p != '\0'; p++)
  {
    if( (c = *p) == '\\' && !escaped && p[1] != '\0' )
    {
      escaped = True;
      continue;
    }

    if( escaped )
    {
      getSpecialChar( c );
    }
    else switch( c )
    {
      case spcMultiple:
        for( ++p; *p == spcMultiple; p++) continue;
        switch( *p )
        {
          case '\0':
            return True;
          case spcMultipleOpen:
            if( zStringMatch( (char *) s, (char *) p, flags) ) return True;
            if( *s == '\0' ) return False;
            do
            {
              s++;
              if( zStringMatch( (char *) s, (char *) p, flags) ) return True;
            }while( *s != '\0' );
            return False;
          case spcSingle:
            if( *(++p) == '\0' && *s != '\0' ) return True;
            while( *s != '\0' )
            {
              s++;
              if( zStringMatch( (char *) s, (char *) p, flags) ) return True;
            }
            return False;
          case spcSingleOpen:
            for( ;; )
            {
              while( *s != '\0' )
              {
                if( (r = zCharMatch( *s, p, flags)) != NULL ) break;
                s++;
              }
              if( *s == '\0' ) return False;
              if( zStringMatch( (char *) (++s), (char *) r, flags) ) return True;
            }
          default:
	    if( (c = *p) == '\\' && p[1] != '\0' )
            {
              c = *(++p);
              getSpecialChar( c );
            }
            if( zCheckFlags( flags, smfCaseIndep) )
            {
              for( c = (unsigned int) _toLower( c ); *s != '\0'; s++)
                if( (unsigned int) _toLower( *s ) == c &&
                    zStringMatch( (char *) (s+1), (char *) (p+1), flags) ) return True;
	    }
	    else
	    {
	      while( (s = (unsigned char *) strchr( (char *) s, c)) != NULL )
                if( zStringMatch( (char *) (++s), (char *) (p+1), flags) ) return True;
            }
            return False;
        }

      case spcMultipleOpen:
        if( (r = zCharMatch( '\0', p, flags)) == NULL ) return False;
        if( zStringMatch( (char *) s, (char *) r, flags) ) return True;
        while( *s != '\0' && zCharMatch( *s, p, flags) != NULL )
        {
	  s++;
          if( zStringMatch( (char *) s, (char *) r, flags) ) return True;
        }
        return False;

      case spcSingle:
	if( *s == '\0' ) return False;
	s++;
        continue;

      case spcSingleOpen:
	if( *s == '\0' ) return False;
        if( (p = zCharMatch( *s, p, flags)) == NULL ) return False;
	p--;
	s++;
        continue;
    }

    if( *s == '\0' ) return False;
    if( zCheckFlags( flags, smfPathSeparator) && (c == '/' || c == '\\') )
    {
      if( *s != SLASH ) return False;
    }
    else if( zCheckFlags( flags, smfCaseIndep) )
    {
      if( _toLower( *s ) != _toLower( c ) ) return False;
    }
    else if( *s != c )
      return False;
    s++;

    escaped = False;
  }

  return (Boolean) (*s == '\0');
}

Boolean zIsPatternString( const char *string )
{
  register const char *s;
  register Boolean escaped;

  for( s = string, escaped = False; *s != '\0'; s++)
    if( escaped )
      escaped = False;
    else
      switch( *s )
      {
        case '\\':
          escaped = True;
          break;
        case spcSingle:
        case spcMultiple:
        case spcSingleOpen:
        case spcMultipleOpen:
          return True;
      }

  return False;
}

Boolean zIsPatternChar( int c )
{
  switch( c )
  {
    case spcSingle:
    case spcMultiple:
    case spcSingleOpen:
    case spcMultipleOpen:
      return True;
    default:
      return False;
  }
}

#ifdef TEST
/***************************************************************************/

static Boolean makeTable( char **xlist, char **ylist)
{
  static char *table = "-|-|****+++++";
  int *xlen, *ylen, xn, yn, xlmax, ylmax, i, j;

  for( xn = 0; xlist[xn] != NULL; xn++) continue;
  for( yn = 0; ylist[yn] != NULL; yn++) continue;
  if( xn == 0 || yn == 0 ) return False;

  if( (xlen = (int *) malloc( xn * sizeof( int ) )) == NULL ) return False;
  if( (ylen = (int *) malloc( yn * sizeof( int ) )) == NULL )
  {
    free( xlen );
    return False;
  }

  for( i = 0, xlmax = 0; i < xn; i++)
    if( (xlen[i] = strlen( xlist[i] )) > xlmax ) xlmax = xlen[i];
  for( i = 0, ylmax = 0; i < yn; i++)
    if( (ylen[i] = strlen( ylist[i] )) > ylmax ) ylmax = ylen[i];

  fputc( table[4], stdout);
  for( i=0; i < xlmax+2; i++) fputc( table[0], stdout);
  fputc( table[8], stdout);
  for( i=0; i < 2*yn+1; i++) fputc( table[0], stdout);
  fputc( table[5], stdout);
  fputs( "\n", stdout);

  for( j=0; j < ylmax; j++)
  {
    fputc( table[1], stdout);
    for( i=0; i < xlmax+2; i++) fputc( ' ', stdout);
    fputc( table[3], stdout);
    for( i=0; i < yn; i++)
    {
      fputc( ' ', stdout);
      fputc( ylen[i] > j ? ylist[i][j] : ' ', stdout);
    }
    fputc( ' ', stdout);
    fputc( table[1], stdout);
    fputs( "\n", stdout);
  }

  fputc( table[9], stdout);
  for( i=0; i < xlmax+2; i++) fputc( table[2], stdout);
  fputc( table[12], stdout);
  for( i=0; i < 2*yn+1; i++) fputc( table[2], stdout);
  fputc( table[11], stdout);
  fputs( "\n", stdout);

  for( j=0; j < xn; j++)
  {
    int l = (xlen[j] > xlmax) ? xlmax : xlen[j];
    fputc( table[1], stdout);
    fputc( ' ', stdout);
    for( i=0; i < l; i++) fputc( xlist[j][i], stdout);
    for( i=l; i < xlmax+1; i++) fputc( ' ', stdout);
    fputc( table[3], stdout);
    for( i=0; i < yn; i++)
    {
      fputc( ' ', stdout);
      fputc( zStringMatch( ylist[i], xlist[j]) ? 'o' : '-', stdout);
    }
    fputc( ' ', stdout);
    fputc( table[1], stdout);
    fputs( "\n", stdout);
  }

  fputc( table[6], stdout);
  for( i=0; i < xlmax+2; i++) fputc( table[0], stdout);
  fputc( table[10], stdout);
  for( i=0; i < yn*2+1; i++) fputc( table[0], stdout);
  fputc( table[7], stdout);
  fputs( "\n", stdout);

  free( xlen );
  free( ylen );
  return True;
}

/***************************************************************************/

char *fn1[] =
{
  "a", "b", "c", "ab", "ba", "aa", "bb", "cc", "ac", "ca", "bc", "cb",
  "abc", "acb", "cab", "bca", "bac",
  "aab", "aba", "baa", "abb", "bab", "bba", "acc", "cac", "cca", "bcc",
    "cbc", "ccb",
  NULL
};

char *fn2[] =
{
  "a.", ".a", "b.", ".b", "c.", ".c",
  "..a", ".a.", "a..", "..b", ".b.", "b..", "..c", ".c.", "c..",
  ".aa", "a.a", "aa.", ".bb", "b.b", "bb.", ".cc", "c.c", "cc.",
  "..aa", ".a.a", ".aa.", "a..a", "a.a.", "aa..",
  NULL
};

char *fn3[] =
{
  "a?", "{a", "b?", "{b", "c?", "{c",
  ".[a", "[a?", "a[]", "{}b", "[b]", "b?{", "{?c", "{c}", "c[]",
  "?aa", "a?a", "aa*", "*bb", "b*b", "bb*", "*cc", "c*c", "cc*",
  "[]aa", "[a]a", "?aa?", "a??a", "a[a]", "aa[]",
  NULL
};

char *fn4[] =
{
  "a", "b", "c", "[", "]", "\\", "-",
  "\\a", "a\\", "\\b", "b\\", "\\c", "c\\", "a-", "-a", "b-", "-b", "c-", "-c",
  "[a", "a[", "[b", "b[", "[c", "c[", "]a", "a]", "]b", "b]", "]c", "c]",
  NULL
};

char *pt1[] =
{
  "a", "ab", "ba", "abc",
  "a*", "*a", "b*", "*b",
  "ab*", "a*b", "*ab", "*ba", "ba*", "b*a",
  "a**", "*a*", "**a", "aa*", "a*a", "*aa",
  "ab**", "a*b*", "a**b", "*a*b", "**ab", "ba**", "b*a*", "b**a", "*b*a",
    "**ba", "*ab*", "*ba*", "*a*b*", "*b*a*",
  "a?", "?a", "b?", "?b",
  "a??", "?a?", "??a", "aa?", "a?a", "?aa",
  "ab?", "a?b", "?ab", "?ba", "b?a", "ba?",
  NULL
};

char *pt2[] =
{
  "a*?", "a?*", "?a*", "?*a", "*?a", "*a?",
  "a?**", "a*?*", "a**?", "*a?*", "*a*?", "**?a", "**a?", "*?a*", "*?*a",
    "?**a", "?*a*", "?a**",
  "a??*", "a?*?", "a*??", "*??a", "*?a?", "*a??", "??*a", "??a*", "?a?*",
    "?a*?", "?*a?", "?*?a",
  "ab*?", "a*b?", "ab?*", "a*?b", "a?b*", "a?*b", "ba?*", "ba*?", "b*?a",
    "b*a?", "b?a*", "b?*a", "*?ab", "*?ba", "*a?b", "*ab?", "*ba?", "*b?a",
  NULL
};

char *pt3[] =
{
  "[a]*", "[b]*", "*[a]", "*[b]", "[ab]*", "*[ab]",
  "[^a]*", "[^b]*", "*[^a]", "*[^b]", "[^ab]*", "*[^ab]",
  "{a}*", "{b}*", "*{a}", "*{b}", "{ab}*", "*{ab}",
  "{^a}*", "{^b}*", "*{^a}", "*{^b}", "{^ab}*", "*{^ab}",
  "[a.]*", "[b.]*", "*[a.]", "*[b.]", "[ab.]*", "*[ab.]",
  "[^a.]*", "[^b.]*", "*[^a.]", "*[^b.]", "[^ab.]*", "*[^ab.]",
  "[a].*", "[b].*", "*.[a]", "*.[b]", "[ab].*", "*.[ab]",
  "[^a].*", "[^b].*", "*.[^a]", "*.[^b]", "[^ab].*", "*.[^ab]",
  "{a}.*", "{b}.*", "*.{a}", "*.{b}", "{ab}.*", "*.{ab}",
  "{^a}.*", "{^b}.*", "*.{^a}", "*.{^b}", "{^ab}.*", "*.{^ab}",
  NULL
};

char *pt4[] =
{
  "[\\a]*", "\\[b]*", "*[a\\]", "\\*[b]*", "[\\a\\b]*", "*[\\a\\b]",
  "[\\^a]*", "[\\^\\b]\*", "*[^a]\\", "*[^b]\\", "[^\\a\\b]*", "*[\\^ab]",
  "{\\a}*", "\\{b}*", "\\*{\\a}", "*{b\\}", "{\\a\\b}*", "*{\\a\\b}",
  "{^\\a}??", "?{^\\b}?", "?{^a}", "?{^b}", "{^ab}?", "?{^ab}",
  "[a\\?]?", "[b\\]]??", "?[a\\[]?", "?[b\\?]?", "?[ab\\}]?", "?[ab\\{]?",
  "[^\\a\\?]?*", "*[^\\b\\]]?*", "*[^a\\]]", "*[^b\\]]", "\\?[^ab?]*", "\\*[^ab.]",
  "[\\a]\\?*", "[b]\\?*", "*\\[[a-c]", "*\\?[a-c]", "[a-c]?*", "*?[a-c]",
  "[^a-c]?*", "[^b\\]]\\[*", "*\\[[^a-c]", "**[^b?\\]]",
  "*[^\\a\\b\\]]\\[*", "*[^a-c]*", "{a-c}\\?*", "*?{a-z\\?\\}}?*",
  "*\\?{a-z}*", "*\\{{a-z\\}\\{}*", "*[a-z]{a-z}?[]]", "*\\[{^a-b}]*",
  NULL
};

char *pt5[] =
{
  "*[]]*", "*[\\]]*", "*[\\b-\\z]*", "*[^]]*", "*[\\^]]*", "*[^\\]]*",
  "*[\\\\c]*", "[\\a\\-\\c]*", "\\[[\\a\\-\\c]*",
  NULL
};

void main()
{
  zInitLowerRussians();
/*  makeTable( pt1, fn1); */
/*  makeTable( pt1, fn2); */
/*  makeTable( pt2, fn1); */
/*  makeTable( pt2, fn2); */
/*  makeTable( pt3, fn1); */
/*  makeTable( pt3, fn2); */
  makeTable( pt5, fn4);
/*  fputs( stringMatch( "a[]", "*\\[{^a-b}]*") ? "o\n" : "-\n", stdout); */
}
#endif
