/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"

#include "zstdlib.h"

int zGetEndian()
{
  unsigned zint_t test = __ZINT(0x06070809u);
  unsigned char *ptr = (unsigned char *) &test;

  if( ptr[0] == 9 && ptr[1] == 8 && ptr[2] == 7 && ptr[3] == 6 )
    return Z_BIG_ENDIAN;
  if( ptr[SIZEOF_ZINT-4] == 6 && ptr[SIZEOF_ZINT-3] == 7 &&
      ptr[SIZEOF_ZINT-2] == 8 && ptr[SIZEOF_ZINT-1] == 9 )
    return Z_LITTLE_ENDIAN;
  return Z_UNKNOWN_ENDIAN;
}

unsigned zint_t zGetLong( const unsigned char *s, Boolean bigEndian)
{
  return bigEndian ?
    ((((unsigned zint_t) s[0]) << 24) |
     (((unsigned zint_t) s[1]) << 16) |
     (((unsigned zint_t) s[2]) << 8) |
      ((unsigned zint_t) s[3]))
    :
    ((((unsigned zint_t) s[3]) << 24) |
     (((unsigned zint_t) s[2]) << 16) |
     (((unsigned zint_t) s[1]) << 8) |
      ((unsigned zint_t) s[0]))
    ;
}

unsigned zshort_t zGetShort( const unsigned char *s, Boolean bigEndian)
{
  return bigEndian ?
    ((unsigned zshort_t) (((unsigned zshort_t) s[0]) << 8) |
      ((unsigned zshort_t) s[1]))
    :
    ((unsigned zshort_t) (((unsigned zshort_t) s[1]) << 8) |
      ((unsigned zshort_t) s[0]))
    ;
}

void zSetLong( unsigned char *s, unsigned zint_t num, Boolean bigEndian)
{
  if( bigEndian )
  {
    s[3] = (unsigned char) num;
    num >>= 8;
    s[2] = (unsigned char) num;
    num >>= 8;
    s[1] = (unsigned char) num;
    num >>= 8;
    s[0] = (unsigned char) num;
  }
  else
  {
    s[0] = (unsigned char) num;
    num >>= 8;
    s[1] = (unsigned char) num;
    num >>= 8;
    s[2] = (unsigned char) num;
    num >>= 8;
    s[3] = (unsigned char) num;
  }
}

void zSetShort( unsigned char *s, unsigned zshort_t num, Boolean bigEndian)
{
  if( bigEndian )
  {
    s[1] = (unsigned char) num;
    num >>= 8;
    s[0] = (unsigned char) num;
  }
  else
  {
    s[0] = (unsigned char) num;
    num >>= 8;
    s[1] = (unsigned char) num;
  }
}
