/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "zstdlib.h"

unsigned zint_t rotateBits( unsigned zint_t v, int count, int bytes)
{
  Boolean direction = (Boolean) (count > 0);
  unsigned zint_t border;

  if( count < 0 ) count = -count;

  switch( bytes )
  {
    case 1:
      border = __ZINT(0x80u);
      break;
    case 2:
      border = __ZINT(0x8000u);
      break;
    default:
      border = __ZINT(0x80000000u);
      break;
  }

  while( count-- > 0 )
  {
    if( direction )
      if( (v & __ZINT(0x01u)) != 0 )
      {
        v >>= 1;
	v |= border;
      }
      else
        v >>= 1;
    else
      if( (v & border) != 0 )
      {
        v <<= 1;
        v |= __ZINT(0x01u);
      }
      else
        v <<= 1;
  }

  return v;
}
