/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */

#include "zstdlib.h"

unsigned zint_t zGetStatusByName( const struct zstatus_t *table, const char *name)
{
  for( ; table->name != NULL; table++)
    if( strcasecmp( table->name, name) == 0 ) return table->flag;

  return 0;
}

const char *zGetStatusByFlag( const struct zstatus_t *table, unsigned zint_t flag)
{
  for( ; table->name != NULL; table++)
    if( (table->flag & flag) != 0 ) return table->name;

  return NULL;
}

const char *zGetStatusByValue( const struct zstatus_t *table, unsigned zint_t flag)
{
  for( ; table->name != NULL; table++)
    if( table->flag == flag ) return table->name;

  return NULL;
}

