/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "zcontext.h"
#include "zcoll.h"
#include "zstdio.h"

ZFUN(void) zioSaveInfo( struct zcontext_t *cnt, struct zioinfo_t *info)
{
  ZIO_SAVE( info, cnt);
}

ZFUN(void) zioRestoreInfo( struct zcontext_t *cnt, struct zioinfo_t *info)
{
  ZIO_RESTORE( cnt, info);
}

ZFUN(void) zioSetOutputStrbuf( struct zcontext_t *cnt, struct zstrbuf_t *sb, struct zioinfo_t *info)
{
  if( sb == NULL )
  {
    if( info != NULL )
      zioRestoreInfo( cnt, info);
    else
    {
      cnt->ioStrbuf = NULL;
      cnt->ioDirection = zioDirectionStream;
    }
  }
  else
  {
    if( info != NULL ) zioSaveInfo( cnt, info);
    cnt->ioStrbuf = sb;
    zSetFlags( sb->flags, zcfSolid);
    cnt->ioDirection = zioDirectionStrbuf;
  }
}

ZFUN(void) zioSetOutputStream( struct zcontext_t *cnt, FILE *stream, struct zioinfo_t *info)
{
  if( info != NULL ) zioSaveInfo( cnt, info);
  cnt->output = stream;
  cnt->ioDirection = zioDirectionStream;
}

ZFUN(void) zioSetOutputFunction( struct zcontext_t *cnt, zwrite_t writeFunc,
    zflush_t flushFunc, struct zioinfo_t *info)
{
  if( writeFunc == NULL )
  {
    if( info != NULL )
      zioRestoreInfo( cnt, info);
    else
    {
      cnt->output = NULL;
      cnt->ioWrite = NULL;
      cnt->ioFlush = NULL;
      cnt->ioDirection = zioDirectionStream;
    }
  }
  else
  {
    if( info != NULL ) zioSaveInfo( cnt, info);
    cnt->ioWrite = writeFunc;
    cnt->ioFlush = flushFunc;
    cnt->ioDirection = zioDirectionFunction;
  }
}
