/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstdio.h" /* <stdio.h> */
#include "_pstring.h" /* <string.h> */
#include <stdarg.h>

#include "zcontext.h"
#include "zerror.h"
#include "zcoll.h"
#include "zstdio.h"

ZFUN(Boolean) zsprintf( char *string, int size, const char *fmt, ...)
{
  struct zcontext_t context;
  struct zstrbuf_t strBuf;
  Boolean success;
  va_list args;

  zContextInit( &context, NULL, NULL, NULL, 0);
  (void) zStringBufferInit( &context, &strBuf, string, size, 0);
  zioSetOutputStrbuf( &context, &strBuf, NULL);

  va_start( args, fmt);
  success = zvprintf( &context, fmt, args);
  va_end( args );

  return success;
}

ZFUN(Boolean) ztprintf( struct zcontext_t *cnt, char *string, int size, const char *fmt, ...)
{
  struct zioinfo_t ioInfo;
  struct zstrbuf_t strBuf;
  Boolean success;
  va_list args;

  ZIO_SAVE( &ioInfo, cnt);
  (void) zStringBufferInit( cnt, &strBuf, string, size, 0);
  zioSetOutputStrbuf( cnt, &strBuf, NULL);

  va_start( args, fmt);
  success = zvprintf( cnt, fmt, args);
  va_end( args );

  ZIO_RESTORE( cnt, &ioInfo);
  return success;
}

ZFUN(char *) zaprintf( struct zcontext_t *cnt, const char *fmt, ...)
{
  struct zioinfo_t ioInfo;
  struct zstrbuf_t strBuf;
  va_list args;
  Boolean success;

  ZIO_SAVE( &ioInfo, cnt);
  (void) zStringBufferInit( cnt, &strBuf, NULL, 0, 16);
  zioSetOutputStrbuf( cnt, &strBuf, NULL);
  zUnsetFlags( cnt->ioFlags, ZCONTEXT_IOFLAG_CHARSET_RECODE);

  va_start( args, fmt);
  success = zvprintf( cnt, fmt, args);
  va_end( args );

  if( !success ) zStringBufferFree( &strBuf );
  ZIO_RESTORE( cnt, &ioInfo);
  return success ? strBuf.buffer : NULL;
}

ZFUN(char *) zbprintf( struct zcontext_t *cnt, const char *fmt, ...)
{
  struct zioinfo_t ioInfo;
  struct zstrbuf_t strBuf;
  va_list args;
  Boolean success;

  ZIO_SAVE( &ioInfo, cnt);
  (void) zStringBufferInit( cnt, &strBuf, NULL, 0, 16);
  zioSetOutputStrbuf( cnt, &strBuf, NULL);

  va_start( args, fmt);
  success = zvprintf( cnt, fmt, args);
  va_end( args );

  if( !success ) zStringBufferFree( &strBuf );
  ZIO_RESTORE( cnt, &ioInfo);
  return success ? strBuf.buffer : NULL;
}
