/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstdio.h" /* <stdio.h> */
#include "_pstring.h" /* <string.h> */
#include <stdarg.h>

#include "zcontext.h"
#include "zerror.h"
#include "zstdio.h"

ZFUN(Boolean) zprintf( struct zcontext_t *cnt, const char *fmt, ...)
{
  Boolean success;
  va_list args;

  va_start( args, fmt);
  success = zvprintf( cnt, fmt, args);
  va_end( args );

  return success;
}

ZFUN(Boolean) zfprintf( struct zcontext_t *cnt, FILE *stream, const char *fmt, ...)
{
  struct zcontext_t context;
  Boolean success;
  va_list args;

  if( cnt == NULL )
    zContextInit( &context, NULL, NULL, NULL, 0);
  else
    zContextCopy( &context, cnt);
  zioSetOutputStream( &context, stream, NULL);

  va_start( args, fmt);
  success = zvprintf( &context, fmt, args);
  va_end( args );

  return success;
}
