/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstdio.h" /* <stdio.h> */
#include "_pstring.h" /* <string.h> */
#include <stdarg.h>
#include <limits.h>

#include "zcontext.h"
#include "zcoll.h"
#include "zstdio.h"

#define _pfCharValue                   0x0001u
#define _pfIntValue                    0x0002u
#define _pfLong                        0x0004u
#define _pfShort                       0x0008u
#define _pfUnsigned                    0x0010u
#define _pfLowerHex                    0x0020u
#define _pfUpperHex                    0x0040u
#define _pfOctet                       0x0080u
#define _pfPrefix                      0x0100u
#define _pfLeftPadding                 0x0200u
#define _pfZeroPadding                 0x0400u
#define _pfExtendedPrecision           0x0800u
#define _pfNotBlank                    0x1000u

static const char *getInteger( register unsigned long value, char *line,
    unsigned int flags)
{
  register char *s = line;

  if( zCheckFlags( flags, _pfLowerHex | _pfUpperHex) )
  {
    const char *hex = zCheckFlags( flags, _pfUpperHex) ?
      "0123456789ABCDEF" : "0123456789abcdef";

    do
    {
      *--s = hex[ (int) (value & 0x0f) ];
      value >>= 4;
    } while( value != 0 );
  }
  else if( zCheckFlags( flags, _pfOctet) )
  {
    do
    {
      *--s = (int) (value & 0x07) + '0';
      value >>= 3;
    } while( value != 0 );
  }
  else
  {
    register long lval;

    if( value > LONG_MAX )
    {
      *--s = (int) (value % 10) + '0';
      lval = value / 10;
    }
    else
      lval = value;

    do
    {
      *--s = (int) (lval % 10) + '0';
      lval /= 10;
    } while( lval != 0 );
  }

  return s;
}

#define IS_DIGIT(x) ((unsigned int) (x) >= '0' && (unsigned int) (x) <= '9')

#define GET_VALUE(value,vtype,atype)                    \
    do                                                  \
    {                                                   \
      if( zCheckFlags( flags, _pfLowerHex | _pfUpperHex | _pfOctet | _pfUnsigned) ) \
	ulval = (unsigned long) ((unsigned vtype) va_arg( args, unsigned atype)); \
      else                                              \
      {                                                 \
	if( (value = (vtype) va_arg( args, atype)) < 0 ) \
	{                                               \
	  sign = '-';                                   \
	  value = (vtype) (-value);                     \
	}                                               \
	ulval = (unsigned long) value;                  \
      }                                                 \
    } while( 0 )

/* All but isFormat & last */
#define INIT_PARAMS()       \
    flags = 0;              \
    printFlags = 0;         \
    width = precision = -1; \
    sign = '\0'

#define MAKE_PADDING(s,f,b) \
    do                      \
    {                       \
      int length;           \
      for( length = s; length > 0; length -= 64) \
        if( !(success = zPrintData( cnt, f, b, (length > 64) ? 64 : length)) ) break; \
    } while( 0 )

static const char blanks[64] =
{
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '
};

static const char zeroes[64] =
{
  '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0',
  '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0',
  '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0',
  '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'
};

ZFUN(Boolean) zvprintf( struct zcontext_t *cnt, const char *fmt, va_list args)
{
  const char *s;
  char c;
  unsigned int flags, printFlags;
  const char *last;
  Boolean success = True, isFormat;
  char sign;
  int width, precision, dontPrint = 0, dontRecode = 0;
  char buf[1024];

  if( /* XXX: cnt->ioDirection != zioDirectionStream || */
      zCheckFlags( cnt->ioFlags, ZCONTEXT_IOFLAG_NO_INTERNAL_BUFFER) ||
      (fmt[0] == '%' && fmt[1] == '~' && fmt[2] == 's' && fmt[3] == '\0') )
    zUnsetFlags( cnt->ioFlags, ZCONTEXT_IOFLAG_INTERNAL_BUFFER);
  else
  {
    cnt->ioBuf = buf;
    cnt->ioBufSize = sizeof(buf);
    cnt->ioBufLength = 0;
    zSetFlags( cnt->ioFlags, ZCONTEXT_IOFLAG_INTERNAL_BUFFER);
  }
  INIT_PARAMS();

  for( s = last = fmt, isFormat = False; success && (c = *s) != '\0'; s++)
    if( isFormat )
    {
      const char *writePtr;
      char buf[64];
      int writeSize, realSize;
      unsigned long ulval;

      switch( c )
      {
        case '\n':
          zSetFlags( printFlags, zpfBreakLine);
          continue;
        case ' ':
          if( sign == '\0' ) sign = ' ';
          zSetFlags( printFlags, zpfEscapedSpace);
          continue;
        case '\"':
          zSetFlags( printFlags, zpfEscapedQuote);
          continue;
        case '#':
          zSetFlags( flags, _pfPrefix);
          continue;
        case '*':
          if( (width = va_arg( args, int)) < 0 )
          {
            width = -width;
            zSetFlags( flags, _pfLeftPadding);
          }
          continue;
        case '+':
          sign = '+';
          zSetFlags( flags, _pfNotBlank);
          continue;
        case '-':
          zSetFlags( flags, _pfLeftPadding);
          continue;
        case '.':
          precision = 0;
          zUnsetFlags( flags, _pfExtendedPrecision);
          if( s[1] == '*' )
          {
            zSetFlags( flags, _pfExtendedPrecision);
            precision = va_arg( args, int);
            s++;
          }
          else if( IS_DIGIT( s[1] ) )
            do
            {
              s++;
              precision = 10 * precision + (s[0] - '0');
            } while( IS_DIGIT( s[1] ) );
          continue;
        case '0':
          zSetFlags( flags, _pfZeroPadding);
          continue;
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':
          for( width = 0; ; s++)
          {
            width = 10 * width + (s[0] - '0');
            if( !IS_DIGIT( s[1] ) ) break;
          }
          continue;
        case 'A':
          zSetFlags( printFlags, zpfStrictEscaped);
          goto fp;
        case 'a':
          zSetFlags( printFlags, zpfEscaped);
          goto fp;
        case 'C':
          zSetFlags( printFlags, zpfText);
        case 'c':
          zSetFlags( flags, _pfCharValue);
          buf[0] = (char) va_arg( args, int);
          writePtr = buf;
          writeSize = (precision == 0) ? 0 : 1;
          break;
        case 'D':
        case 'I':
fD:         {
            zlong_t lval;
            zint_t ival;
            zshort_t sval;
            if( zCheckFlags( flags, _pfLong) )
              GET_VALUE( lval, zlong_t, zlong_t);
            else if( zCheckFlags( flags, _pfShort) )
              GET_VALUE( sval, zshort_t, int);
            else
              GET_VALUE( ival, zint_t, zint_t);
          }
          goto fv;
        case 'd':
        case 'i':
fd:       {
            long lval;
            int ival;
            short sval;
            if( zCheckFlags( flags, _pfLong) )
              GET_VALUE( lval, long, long);
            else if( zCheckFlags( flags, _pfShort) )
              GET_VALUE( sval, short, int);
            else
              GET_VALUE( ival, int, int);
          }
fv:       if( ulval == 0 ) zUnsetFlags( flags, _pfPrefix);
fi:       if( precision >= 0 ) zUnsetFlags( flags, _pfZeroPadding);
          if( dontPrint || (ulval == 0 && precision == 0)  )
            writeSize = 0;
          else
          {
            writePtr = getInteger( ulval, buf+sizeof(buf), flags);
            writeSize = sizeof(buf) - (int) (writePtr - (const char *) buf);
          }
          zSetFlags( printFlags, zpfDontRecode);
          zSetFlags( flags, _pfIntValue);
          break;
        case 'h':
          zSetFlags( flags, _pfShort);
          continue;
        case 'l':
          zSetFlags( flags, _pfLong);
          continue;
        case 'o':
          zSetFlags( flags, _pfOctet);
          goto fd;
        case 'P':
          zSetFlags( flags, _pfPrefix | _pfUpperHex);
          ulval = (unsigned long) va_arg( args, void *);
          goto fi;
        case 'p':
          zSetFlags( flags, _pfPrefix | _pfLowerHex);
          ulval = (unsigned long) va_arg( args, void *);
          goto fi;
        case 'S':
          zSetFlags( flags, _pfExtendedPrecision);
          goto fp;
        case 's':
fs:       zUnsetFlags( flags, _pfExtendedPrecision);
fp:       writePtr = (const char *) va_arg( args, char *);
          if( dontPrint || precision == 0 )
          {
            writeSize = 0;
            writePtr = ""; /* On any case */
          }
          else if( zCheckFlags( printFlags, zpfStrictText | zpfText) &&
                   zCheckFlags( flags, _pfPrefix) &&
                   (writePtr == NULL || *writePtr == '\0') )
          {
            writePtr = "&nbsp;";
            writeSize = 6;
            printFlags = zpfDontRecode;
          }
          else if( zCheckFlags( flags, _pfNotBlank) &&
                   writePtr == NULL )
          {
            writeSize = 0;
            writePtr = ""; /* On any case */
          }
          else
          {
            if( writePtr == NULL )
            {
              writePtr = "(null)";
              if( zCheckFlags( flags, _pfExtendedPrecision) && precision > 6 ) precision = 6;
            }
            if( precision > 0 )
            {
              if( zCheckFlags( flags, _pfExtendedPrecision) )
                writeSize = precision;
              else
              {
                const char *ptr = memchr( writePtr, '\0', precision);
                if( ptr == NULL )
                  writeSize = precision;
                else if( (writeSize = (int) (ptr - writePtr)) > precision ) /* on any case */
                  writeSize = precision;
              }
            }
            else
              writeSize = strlen( writePtr );
          }
          break;
        case 'T':
          zSetFlags( printFlags, zpfStrictText);
          goto fs;
        case 't':
          zSetFlags( printFlags, zpfText);
          goto fs;
        case 'U':
          sign = '\0';
          zSetFlags( flags, _pfUnsigned);
          goto fD;
        case 'u':
          sign = '\0';
          zSetFlags( flags, _pfUnsigned);
          goto fd;
        case 'V':
          zSetFlags( printFlags, zpfStrictValue);
          goto fs;
        case 'v':
          zSetFlags( printFlags, zpfValue);
          goto fs;
        case 'X':
          zSetFlags( flags, _pfUpperHex);
          goto fd;
        case 'x':
          zSetFlags( flags, _pfLowerHex);
          goto fd;
        case '_':
          zSetFlags( printFlags, zpfLowerCase);
          continue;
        case '^':
          zSetFlags( printFlags, zpfUpperCase);
          continue;
        case '~':
          zSetFlags( printFlags, zpfDontRecode);
          continue;
        default:
          isFormat = False;
          if( c == '%' ) goto nf;
          INIT_PARAMS(); /* XXX:   ᥬ,  - 譥,   㤥 */
          continue;
      }

      if( !dontPrint )
      {
	if( width > 0 )
        {
          if( zCheckFlags( flags, _pfCharValue) )
            realSize = (precision >= 0) ? precision : writeSize;
          else if( zCheckFlags( flags, _pfIntValue) )
          {
            realSize = ZMAX( precision, writeSize);
            if( zCheckFlags( flags, _pfLowerHex | _pfUpperHex | _pfOctet) )
            {
              if( zCheckFlags( flags, _pfPrefix) )
              {
                realSize++;
                if( zCheckFlags( flags, _pfLowerHex | _pfUpperHex) ) realSize++;
              }
            }
            else if( sign != '\0' )
              realSize++;
          }
          else
            realSize = writeSize;

          if( !zCheckFlags( flags, _pfLeftPadding) && width > realSize )
            if( !zCheckFlags( flags, _pfIntValue) || !zCheckFlags( flags, _pfZeroPadding) )
              MAKE_PADDING( width - realSize, zpfDontRecode, blanks);
        }

        if( success && zCheckFlags( flags, _pfIntValue) )
        {
          if( zCheckFlags( flags, _pfLowerHex | _pfUpperHex | _pfOctet) )
          {
            if( zCheckFlags( flags, _pfPrefix) )
              if( zCheckFlags( flags, _pfLowerHex | _pfUpperHex) )
                success = zPrintData( cnt, zpfDontRecode, "0x", 2);
              else
                success = zPrintData( cnt, zpfDontRecode, "0", 1);
          }
          else if( sign != '\0' )
            success = zPrintData( cnt, zpfDontRecode, &sign, 1);

          if( success && zCheckFlags( flags, _pfZeroPadding) && width > 0 &&
              !zCheckFlags( flags, _pfLeftPadding) && width > realSize )
            MAKE_PADDING( width - realSize, zpfDontRecode, zeroes);

          if( success && precision > writeSize )
            MAKE_PADDING( precision - writeSize, zpfDontRecode, zeroes);
        }

        if( success )
          if( precision >= 2 && zCheckFlags( flags, _pfCharValue) )
          {
            int size = ZMIN( precision, 64), i;
            for( i = 1; i < size; i++) buf[i] = buf[0];
            MAKE_PADDING( precision, printFlags, buf);
          }
          else if( writeSize > 0 )
            success = zPrintData( cnt, printFlags, writePtr, writeSize);

        if( success && width > 0 && zCheckFlags( flags, _pfLeftPadding) && width > realSize )
          MAKE_PADDING( width - realSize, zpfDontRecode, blanks);
      }

      isFormat = False;
      last = &s[1];
    }
    else if( c == '%' )
    {
nf:   switch( s[1] )
      {
        case '%':
          s++;
          if( s != last && !dontPrint ) success = zPrintData( cnt, dontRecode ? zpfDontRecode : 0, last, (int) (s - last));
          last = &s[1];
          break;
        case '[':
          if( s != last && !dontPrint ) success = zPrintData( cnt, dontRecode ? zpfDontRecode : 0, last, (int) (s - last));
          s++;
	  last = &s[1];
	  {
	    int ival = (int) va_arg( args, int);
	    if( dontPrint || ival == 0 ) dontPrint++;
	  }
          break;
        case ']':
          if( s != last && !dontPrint ) success = zPrintData( cnt, dontRecode ? zpfDontRecode : 0, last, (int) (s - last));
          s++;
          last = &s[1];
          if( dontPrint > 0 ) dontPrint--;
          break;
        case '{':
          if( s != last && !dontPrint ) success = zPrintData( cnt, dontRecode ? zpfDontRecode : 0, last, (int) (s - last));
          s++;
	  last = &s[1];
          dontRecode++;
          break;
        case '}':
          if( s != last && !dontPrint ) success = zPrintData( cnt, dontRecode ? zpfDontRecode : 0, last, (int) (s - last));
          s++;
	  last = &s[1];
          if( dontRecode > 0 ) dontRecode--;
          break;
        default:
          if( s != last && !dontPrint ) success = zPrintData( cnt, dontRecode ? zpfDontRecode : 0, last, (int) (s - last));
          last = s;
          isFormat = True;
          INIT_PARAMS();
      }
    }

  if( success && s != last && !dontPrint ) success = zPrintData( cnt, dontRecode ? zpfDontRecode : 0, last, (int) (s - last));

  if( success && zCheckFlags( cnt->ioFlags, ZCONTEXT_IOFLAG_INTERNAL_BUFFER) && cnt->ioBufLength > 0 )
  {
    zUnsetFlags( cnt->ioFlags, ZCONTEXT_IOFLAG_INTERNAL_BUFFER);
    success = zPrintData( cnt, zpfDontRecode, cnt->ioBuf, cnt->ioBufLength);
  }
  zUnsetFlags( cnt->ioFlags, ZCONTEXT_IOFLAG_INTERNAL_BUFFER);

  if( success && zCheckFlags( cnt->ioFlags, ZCONTEXT_IOFLAG_AUTOFLUSH) )
    success = zflush( cnt );

  return success;
}
