/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstdio.h" /* <stdio.h> */
#include "_pstring.h" /* <string.h> */

#include "zcontext.h"
#include "zchars.h"
#include "zcoll.h"
#include "zstdio.h"

ZFUN(Boolean) zflush( struct zcontext_t *cnt )
{
  switch( cnt->ioDirection )
  {
    case zioDirectionStrbuf:
      break;
    case zioDirectionFunction:
      if( cnt->ioFlush != NULL ) return cnt->ioFlush( cnt );
      break;
    default:
      return (Boolean) (fflush( cnt->output == NULL ? stdout : cnt->output) == 0);
  }

  return True;
}

#define PRINT_DATA(d,l) \
    switch( cnt->ioDirection ) \
    {                   \
      case zioDirectionStrbuf: \
        if( !zStringBufferAddData( cnt->ioStrbuf, (d), (l)) ) success = False; \
	break;          \
      case zioDirectionFunction: \
        if( cnt->ioWrite( cnt, (d), (l)) < 0 ) success = False; \
        break;          \
      default:          \
        if( fwrite( (d), (l), 1, output) != 1 ) success = False; \
    }

ZFUN(Boolean) zPrintData( struct zcontext_t *cnt, unsigned int flags, const char *data, int length)
{
  Boolean success = True;

  if( length < 0 ) length = strlen( data );

  if( length > 0 )
  {
    char *buf, locBuf[1024];
    int i, c, sp, bufLength, bufSize;
    FILE *output = (cnt->output == NULL) ? stdout : cnt->output;
    Boolean doFormat = (Boolean) zCheckFlags( flags, zpfText | zpfStrictText |
                                                   zpfValue | zpfStrictValue |
                                               zpfEscaped | zpfStrictEscaped |
                                                 zpfUpperCase | zpfLowerCase);
#ifdef RUSSIAN_SUPPORT
    Boolean doRecode;
    const unsigned char *table;

    if( zCheckFlags( flags, zpfStrictEscaped | zpfStrictText | zpfStrictValue) ||
        (zCheckFlags( cnt->ioFlags, ZCONTEXT_IOFLAG_STRICT_VALUE) &&
         zCheckFlags( flags, zpfValue)) )
    {
      doRecode = (Boolean) (!zCheckFlags( flags, zpfDontRecode) &&
        zCheckFlags( cnt->ioFlags, ZCONTEXT_IOFLAG_CHARSET_RECODE_STRICT) &&
	cnt->recodeStrictTable != NULL);
      table = (const unsigned char *) cnt->recodeStrictTable;
    }
    else
    {
      doRecode = (Boolean) (!zCheckFlags( flags, zpfDontRecode) &&
        zCheckFlags( cnt->ioFlags, ZCONTEXT_IOFLAG_CHARSET_RECODE) && cnt->recodeTable != NULL);
      table = (const unsigned char *) cnt->recodeTable;
    }
#endif

    if( zCheckFlags( cnt->ioFlags, ZCONTEXT_IOFLAG_INTERNAL_BUFFER) )
    {
      buf = cnt->ioBuf;
      bufSize = cnt->ioBufSize;
      bufLength = cnt->ioBufLength;
    }
    else
    {
      buf = locBuf;
      bufSize = sizeof( locBuf );
      bufLength = 0;
    }

    if(
#ifdef RUSSIAN_SUPPORT
        !doRecode &&
#endif
                     !doFormat )
    {
      if( zCheckFlags( cnt->ioFlags, ZCONTEXT_IOFLAG_INTERNAL_BUFFER) )
      {
        /*  ᢮ 祪   */
        if( bufLength > 0 )
        {
	  if( length > bufSize-bufLength && zCheckFlags( flags, zpfFlush | zpfLast) )
          {
            PRINT_DATA( buf, bufLength);
            bufLength = 0;
          }
          else
          {
            sp = bufSize - bufLength;
            sp = ZMIN( sp, length);
            for( i = 0; i < sp; i++) buf[bufLength++] = data[i];
            data += sp;
            length -= sp;
            if( bufLength >= bufSize )
            {
              PRINT_DATA( buf, bufLength);
              bufLength = 0;
            }
          }
        }
        /* ⠥ ,      */
	if( success && length > 0 && (length > bufSize || zCheckFlags( flags, zpfFlush | zpfLast)) )
        {
          PRINT_DATA( data, length);
          length = 0;
        }
        /* 孥   ⪨  */
        if( success && length > 0 )
          for( i = 0; i < length; i++) buf[bufLength++] = data[i];
      }
      else
      {
        PRINT_DATA( data, length);
      }
    }
    else if( zCheckFlags( flags, zpfEscaped | zpfStrictEscaped) )
      for( i = 0; ; i++)
      {
	if( (bufSize - bufLength) < 4 || (!zCheckFlags( cnt->ioFlags, ZCONTEXT_IOFLAG_INTERNAL_BUFFER) && i >= length) )
        {
          PRINT_DATA( buf, bufLength);
          bufLength = 0;
          if( !success ) break;
        }
        if( i >= length ) break;

        c = ((const unsigned char *) data)[i];
        if( zCheckFlags( flags, zpfUpperCase) )
          c = ((unsigned char *) ztUpperTable)[c];
        else if( zCheckFlags( flags, zpfLowerCase) )
          c = ((unsigned char *) ztLowerTable)[c];

        switch( c )
        {
          case '\"':
	  case '\\':
	    buf[bufLength++] = '\\';
	    buf[bufLength++] = (char) c;
	    break;
	  case '\n':
	    buf[bufLength++] = '\\';
	    buf[bufLength++] = 'n';
            break;
          case '\r':
	    buf[bufLength++] = '\\';
	    buf[bufLength++] = 'r';
	    break;
	  case '\t':
	    buf[bufLength++] = '\\';
	    buf[bufLength++] = 't';
	    break;
	  case '\b':
	    buf[bufLength++] = '\\';
	    buf[bufLength++] = 'b';
	    break;
	  default:
#ifdef RUSSIAN_SUPPORT
            if( doRecode && (c & 0x80) != 0 ) c = table[ (c & 0x7f) ];
#endif
            if( c < ' ' || (zCheckFlags( flags, zpfStrictEscaped) && (c & 0x80) != 0) )
            {
	      buf[bufLength++] = '\\';
	      buf[bufLength++] = 'x';
	      buf[bufLength++] = zUpperHex( (c >> 4) );
	      buf[bufLength++] = zUpperHex( c );
	    }
            else
	      buf[bufLength++] = (char) c;
        }
      }
    else if( zCheckFlags( flags, zpfText | zpfStrictText) )
      for( i = 0; ; i++)
      {
        if( (bufSize - bufLength) < 6 || (!zCheckFlags( cnt->ioFlags, ZCONTEXT_IOFLAG_INTERNAL_BUFFER) && i >= length) )
	{
          PRINT_DATA( buf, bufLength);
          bufLength = 0;
          if( !success ) break;
        }
        if( i >= length ) break;

        c = ((const unsigned char *) data)[i];
        if( zCheckFlags( flags, zpfUpperCase) )
          c = ((unsigned char *) ztUpperTable)[c];
        else if( zCheckFlags( flags, zpfLowerCase) )
          c = ((unsigned char *) ztLowerTable)[c];

        switch( c )
        {
          case '&':
            buf[bufLength++] = '&';
            buf[bufLength++] = 'a';
            buf[bufLength++] = 'm';
            buf[bufLength++] = 'p';
            buf[bufLength++] = ';';
            break;
          case '<':
            buf[bufLength++] = '&';
            buf[bufLength++] = 'l';
            buf[bufLength++] = 't';
            buf[bufLength++] = ';';
            break;
          case '>':
            buf[bufLength++] = '&';
            buf[bufLength++] = 'g';
            buf[bufLength++] = 't';
            buf[bufLength++] = ';';
	    break;
          default:
            if( c == '\"' && zCheckFlags( flags, zpfEscapedQuote) )
            {
              buf[bufLength++] = '&';
              buf[bufLength++] = '#';
              buf[bufLength++] = '3';
              buf[bufLength++] = '4';
              buf[bufLength++] = ';';
            }
            else if( c == ' ' && zCheckFlags( flags, zpfEscapedSpace) )
            {
              buf[bufLength++] = '&';
              buf[bufLength++] = 'n';
              buf[bufLength++] = 'b';
              buf[bufLength++] = 's';
              buf[bufLength++] = 'p';
              buf[bufLength++] = ';';
            }
            else if( c == '\n' && zCheckFlags( flags, zpfBreakLine) )
            {
              buf[bufLength++] = '<';
              buf[bufLength++] = 'b';
              buf[bufLength++] = 'r';
              buf[bufLength++] = '>';
              buf[bufLength++] = '\n';
            }
            else
            {
#ifdef RUSSIAN_SUPPORT
              if( doRecode && (c & 0x80) != 0 ) c = table[ (c & 0x7f) ];
#endif
              if( zCheckFlags( flags, zpfStrictText) && (c & 0x80) != 0 )
              {
                buf[bufLength++] = '&';
                buf[bufLength++] = '#';
                buf[bufLength++] = (char) ((c % 100) + '0');
                c %= 100;
                buf[bufLength++] = (char) ((c % 10) + '0');
                c %= 10;
                buf[bufLength++] = (char) (c + '0');
                buf[bufLength++] = ';';
              }
              else
                buf[bufLength++] = (char) c;
            }
        }
      }
    else if( zCheckFlags( flags, zpfValue | zpfStrictValue) )
      for( i = 0; ; i++)
      {
	if( (bufSize - bufLength) < 3 || (!zCheckFlags( cnt->ioFlags, ZCONTEXT_IOFLAG_INTERNAL_BUFFER) && i >= length) )
	{
          PRINT_DATA( buf, bufLength);
          bufLength = 0;
          if( !success ) break;
        }
        if( i >= length ) break;

        c = ((const unsigned char *) data)[i];
        if( zCheckFlags( flags, zpfUpperCase) )
          c = ((unsigned char *) ztUpperTable)[c];
        else if( zCheckFlags( flags, zpfLowerCase) )
          c = ((unsigned char *) ztLowerTable)[c];
#ifdef RUSSIAN_SUPPORT
        if( doRecode && (c & 0x80) != 0 ) c = table[ (c & 0x7f) ];
#endif

        if( c == ' ' )
          buf[bufLength++] = '+';
        else if( isURLSpecial( c ) || c < ' ' ||
                 ((c & 0x80) != 0 && (zCheckFlags( flags, zpfStrictValue) ||
				      zCheckFlags( cnt->ioFlags, ZCONTEXT_IOFLAG_STRICT_VALUE))) )
	{
          buf[bufLength++] = '%';
          buf[bufLength++] = zUpperHex( c >> 4 );
          buf[bufLength++] = zUpperHex( c );
        }
        else
          buf[bufLength++] = (char) c;
      }
#ifdef RUSSIAN_SUPPORT
    else if( zCheckFlags( flags, zpfUpperCase | zpfLowerCase) )
#else
    else
#endif
      for( i = 0; ; i++)
      {
	if( bufLength >= bufSize || (!zCheckFlags( cnt->ioFlags, ZCONTEXT_IOFLAG_INTERNAL_BUFFER) && i >= length) )
	{
          PRINT_DATA( buf, bufLength);
          bufLength = 0;
          if( !success ) break;
        }
        if( bufLength >= length ) break;

	c = ((const unsigned char *) data)[i];
        if( zCheckFlags( flags, zpfUpperCase) )
          c = ztUpperTable[c];
        else
          c = ztLowerTable[c];
#ifdef RUSSIAN_SUPPORT
        if( doRecode && (c & 0x80) != 0 ) c = table[ (c & 0x7f) ];
#endif
        buf[bufLength++] = (char) c;
      }
#ifdef RUSSIAN_SUPPORT
    else
      for( i = 0; ; i++)
      {
	if( bufLength >= bufSize || (!zCheckFlags( cnt->ioFlags, ZCONTEXT_IOFLAG_INTERNAL_BUFFER) && i >= length) )
	{
          PRINT_DATA( buf, bufLength);
          bufLength = 0;
          if( !success ) break;
        }
        if( i >= length ) break;

	if( ((c = ((const unsigned char *) data)[i]) & 0x80) != 0 )
          buf[bufLength++] = (char) table[ (c & 0x7f) ];
        else
	  buf[bufLength++] = (char) c;
      }
#endif

    if( success && zCheckFlags( flags, zpfFlush | zpfLast) && bufLength > 0 )
    {
      PRINT_DATA( buf, bufLength);
      bufLength = 0;
    }
    if( zCheckFlags( cnt->ioFlags, ZCONTEXT_IOFLAG_INTERNAL_BUFFER) )
      cnt->ioBufLength = bufLength;
  }

  if( success && zCheckFlags( flags, zpfFlush) ) success = zflush( cnt );
  return success;
}
