/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstdio.h" /* <stdio.h> */
#include "_pstring.h" /* <string.h> */
#include <errno.h>

#include "zprocess.h"

FILE *zProcessOpen( const char *commandLine, unsigned int flags)
{
  char mode[3];

  mode[0] = zCheckFlags( flags, ZPROCESS_FLAG_WRITE_MODE) ? 'w' : 'r';
  mode[1] = '\0';

#if defined( __MSDOS__ )
  errno = EINVFNC;
  return NULL;
#elif defined( __OS2__ )
  errno = ENOEXEC;
  return NULL;
#elif defined( __WIN32__ ) || defined( WIN32 ) || defined( _WIN32 )
  if( zCheckFlags( flags, ZPROCESS_FLAG_BINARY_MODE | ZPROCESS_FLAG_TEXT_MODE) )
  {
    mode[1] = zCheckFlags( flags, ZPROCESS_FLAG_BINARY_MODE) ? 'b' : 't';
    mode[2] = '\0';
  }
  return _popen( commandLine, mode);
#else /* UNIX */
  return popen( commandLine, mode);
#endif
}

int zProcessClose( FILE *stream )
{
  if( stream == NULL ) return 0;

#if defined( __MSDOS__ )
  errno = EINVFNC;
  return -1;
#elif defined( __OS2__ )
  errno = ENOEXEC;
  return -1;
#elif defined( __WIN32__ ) || defined( WIN32 ) || defined( _WIN32 )
  return _pclose( stream );
#else /* UNIX */
  return pclose( stream );
#endif
}
