/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstdio.h" /* <stdio.h> */
#include "_pstring.h" /* <string.h> */
#include <errno.h>
#if defined( __MSDOS__ )
#include <io.h>
#elif defined( __OS2__ )
#elif defined( __WIN32__ ) || defined( WIN32 ) || defined( _WIN32 )
#include <sys/stat.h>
#include <process.h>
#include <fcntl.h>
#include <io.h>
#else /* UNIX */
#endif

#include "zprocess.h"

Boolean zPipeOpen( int *fds, Boolean binary)
{
  fds[0] = fds[1] = -1;
#if defined( __MSDOS__ )
  errno = EINVFNC;
  return False;
#elif defined( __OS2__ )
  return False;
#elif defined( __WIN32__ ) || defined( WIN32 ) || defined( _WIN32 )
  return (Boolean) (_pipe( fds, 512, (binary ? O_BINARY : O_TEXT) | O_NOINHERIT) == 0);
#else /* UNIX */
   return (Boolean) (pipe( fds ) == 0);
#endif
}

void zPipeClose( int *fds )
{
  int oldErrno = errno;
  ZCLOSE( fds[0] );
  ZCLOSE( fds[1] );
  errno = oldErrno;
}
