/**********************************************************************
 * Implement dirent-style opendir/readdir/closedir on IBM OS/2
 *
 * Functions defined are opendir(), readdir() and closedir() with the
 * same prototypes as the normal dirent.h implementation.
 *
 * Does not implement telldir(), seekdir(), rewinddir() or scandir().
 * The dirent struct is compatible with Unix, except that d_ino is
 * always 1 and d_off is made up as we go along.
 *
 * The DIR typedef is not compatible with Unix.
 **********************************************************************/

#ifndef _DIRENT_H_OS2
#define _DIRENT_H_OS2

#define INCL_NOPM
#define INCL_DOSNLS
#define INCL_DOSPROCESS
#define INCL_DOSDEVICES
#define INCL_DOSDEVIOCTL
#define INCL_DOSERRORS
#define INCL_DOSMISC
#include <os2.h>

#include <sys/stat.h>
#define S_IFMT (S_IFDIR | S_IFREG)

/* struct dirent - not same as Unix */
struct dirent                          /* findbuf3 */
{
  ULONG  oNextEntryOffset;             /* new field */
  FDATE  fdateCreation;
  FTIME  ftimeCreation;
  FDATE  fdateLastAccess;
  FTIME  ftimeLastAccess;
  FDATE  fdateLastWrite;
  FTIME  ftimeLastWrite;
  ULONG  cbFile;
  ULONG  cbFileAlloc;
  ULONG  attrFile;                     /* widened field */
  UCHAR  cchName;
  CHAR   d_name[CCHMAXPATHCOMP];
  LONG   d_ino;                        /* inode (always 1 in OS2) */
  USHORT d_reclen;                     /* length of d_name */
  off_t  d_off;
};

/* typedef DIR - not the same as Unix */
typedef struct
{
  HDIR   hdir;
  char  *path;
  BOOL   first;
  BOOL   finished;
  struct dirent dent;
} DIR;

#ifdef __cplusplus
  extern "C" {
#endif

  DIR*           opendir ( char *path );
  struct dirent *readdir ( DIR  *dir  );
  void           closedir( DIR  *dir  );

#ifdef __cplusplus
  }
#endif

#endif
