/**********************************************************************
 * Implement dirent-style opendir/readdir/closedir on IBM OS/2
 *
 * Functions defined are opendir(), readdir() and closedir() with the
 * same prototypes as the normal dirent.h implementation.
 *
 * Does not implement telldir(), seekdir(), rewinddir() or scandir().
 * The dirent struct is compatible with Unix, except that d_ino is
 * always 1 and d_off is made up as we go along.
 *
 * The DIR typedef is not compatible with Unix.
 **********************************************************************/

#include <string.h>
#include <stdlib.h>
#include <errno.h>

#include "dirent.h"

DIR *opendir( char *path )
{
    DIR*   dir;
    ULONG  found = 1;
    APIRET rc;
    int    len = strlen(path);

    if(( dir = (DIR *)malloc(sizeof(DIR))) == NULL )
      return NULL;

    dir->path = (char*)malloc(len+sizeof(".\\*\0"));

    if( !dir->path )
    {
      free(dir);
      return NULL;
    }

    strcpy(dir->path, path);

    if( len )
    {
      if( dir->path[len-1] == ':' )
      {
          strcat(dir->path, "." );
          ++len;
      }

      if( dir->path[len-1] != '\\' )
          strcat(dir->path, "\\" );
    }

    strcat(dir->path, "*" );

    dir->dent.d_ino = 1;
    dir->dent.d_off = 0;
    dir->first      = 1;
    dir->finished   = 0;
    dir->hdir       = HDIR_CREATE;

    rc = DosFindFirst( dir->path, &(dir->hdir), FILE_READONLY | FILE_HIDDEN | FILE_DIRECTORY,
                    &( dir->dent), sizeof(struct dirent), &found, 1 );


    #if 0
        // for debug purpose
        printf( "path: %s (%u)\n", dir->path, rc );
    #endif

    if( rc != NO_ERROR )
    {
      free(dir->path);
      free(dir);
      return NULL;
    }

    if( !found ) dir->finished = 1;

    return dir;
}

struct dirent *readdir(DIR *dir)
{
    ULONG  found = 1;
    APIRET rc;

    if (!dir)
    {
        errno = ENOTINIT;
        return NULL;
    }

    if( dir->finished ) return NULL;

    if( dir->first )
    {
        /* First call. */
        rc = NO_ERROR;
        dir->first = 0;
    }
    else
    {
        /* Second & subsuquent call. */
        rc = DosFindNext(dir->hdir, &(dir->dent), sizeof(struct dirent), &found);
    }

    if( !found )
    {
        dir->finished = 1;
        return NULL;
    }
    else if( rc != NO_ERROR )
    {
        errno = ENOTEXIST;
        dir->finished = 1;
        return NULL;
    }
    else
    {
        dir->dent.d_reclen = strlen(dir->dent.d_name);
        dir->dent.d_off++;
        return &(dir->dent);
    }
}

void closedir( DIR *dir )
{
    if (dir)
    {
        DosFindClose(dir->hdir);

        if( dir->path )
            free(dir->path);

        free(dir);
    }
}
