/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */

#include "zcontext.h"
#include "zalloc.h"
#include "zstdlib.h"
#include "zstring.h"
#include "zfilter.h"

void zRewriteDataInit( struct zcontext_t *cnt, struct zrewritedata_t *rd,
    zrewritefile_t rewrite, void *info)
{
  rd->context = cnt;
  rd->pattern = NULL;
  rd->startDir = NULL;
  rd->isstd = False;
  rd->needRecursive = False;
  rd->rewrite = rewrite;
  rd->info = info;
}

void zRewriteDataFree( struct zrewritedata_t *rd )
{
  if( !rd->isstd ){ ZFREE( rd->context, rd->startDir); }
}

#if defined( __MSDOS__ ) || defined( __WIN32__ ) || defined( __OS2__ )
#define IS_SLASH(x) ((x) == SLASH || (x) == '/')
#else
#define IS_SLASH(x) ((x) == SLASH)
#endif

Boolean zRewriteDataGetInfo( struct zrewritedata_t *rd, const char *name)
{
  Boolean escaped, needRecursive;
  const char *s, *end;

  for( escaped = False, end = NULL, s = name; *s != '\0'; s++)
  {
    if( escaped )
    {
      escaped = False;
      if( IS_SLASH(*s) ) end = s;
    }
    else if( *s == '\\' )
      escaped = True;
    else if( IS_SLASH(*s) )
      end = s;
    else if( zIsPatternChar( *s ) )
      break;
  }

  for( escaped = needRecursive = False; *s != '\0'; s++)
  {
    if( escaped )
    {
      escaped = False;
      if( IS_SLASH(*s) )
        needRecursive = True;
    }
    else if( *s == '\\' )
      escaped = True;
    else if( IS_SLASH(*s) )
      needRecursive = True;
    else if( *s == spcSingleOpen || *s == spcMultipleOpen )
      if( (s = (const char *) zCharMatch( '\0', (unsigned const char *) s, rd->context->patternFlags)) == NULL )
        return False;
  }

  rd->pattern = name;
  rd->needRecursive = needRecursive;
  if( end == NULL )
  {
    rd->startDir = ".";
    rd->isstd = True;
  }
  else
  {
    int length = (int) (++end - name);
    /* XXX: if NULL? */
    rd->startDir = (char *) zMalloc( rd->context, length+1);
    strncpy( rd->startDir, name, length);
    rd->startDir[length] = '\0';
    zUnescapeString( rd->startDir, False);
#if defined( __MSDOS__ ) || defined( __WIN32__ ) || defined( __OS2__ )
    zStringReplace( rd->startDir, '/', SLASH);
#endif
    if( (length = strlen( rd->startDir )) > 1 && rd->startDir[length-1] == SLASH )
      rd->startDir[length-1] = '\0';
    rd->isstd = False;
  }

  return True;
}
