/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */

#if defined( __BC__ )
#include <dir.h>
#define MKDIR(x,y)        mkdir( x )
#elif defined( __MSVC__ )
#include <direct.h>
#define MKDIR(x,y)        _mkdir( x )
#else
#include "_pstat.h"
#define MKDIR(x,y)        mkdir( x, y)
#endif

#include "zcontext.h"
#include "zalloc.h"
#include "zerror.h"
#include "zstring.h"
#include "zfile.h"

Boolean zCreateDirectory( struct zcontext_t *cnt, const char *dirName, Boolean isFileName)
{
  char *dir, *ptr;
  char cc;

  if( (dir = zStrdup( cnt, dirName)) == NULL ) return False;
#if defined( __MSDOS__ ) || defined( __WIN32__ ) || defined( __OS2__ )
  (void) zStringReplace( dir, '/', SLASH);
#endif

  if( isFileName )
  {
    if( (ptr = strrchr( dir, SLASH)) == NULL || ptr == dir )
    {
      zFree( cnt, dir);
      return True;
    }
    *ptr = '\0';
  }

#if defined( __MSDOS__ ) || defined( __WIN32__ ) || defined( __OS2__ )
  if( (ptr = strchr( dir, ':')) != NULL ) ptr++; else ptr = dir;
#else
  ptr = dir;
#endif
  if( ptr[0] == '\0' || (ptr[0] == SLASH && ptr[1] == '\0') )
  {
    zFree( cnt, dir);
    return True;
  }

  if( *ptr == SLASH ) ptr++;

  for( ;; )
  {
    while( *ptr != '\0' && *ptr != SLASH ) ptr++;
    cc = *ptr;
    *ptr = '\0';

    switch( zFileExist( dir, fefDirExist, NULL) )
    {
      case fesOk:
        break;

      case fesNotDirectory:
        cnt->errorCode = zerNotDirectory;
	zFree( cnt, dir);
        return False;

      case fesNotExist:
	if( MKDIR( dir, 0777) < 0 )
        {
          cnt->errorCode = zerDirCreate;
	  zFree( cnt, dir);
          return False;
        }
        break;

      default:
	cnt->errorCode = zerFileStat; /* XXX: ??? */
	zFree( cnt, dir);
        return False;
    }

    if( cc == '\0' ) break;
    *ptr ++ = cc;
    if( *ptr == '\0' ) break;
  }

  zFree( cnt, dir);
  return True;
}
