/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstdio.h" /* <stdio.h> */
#include "_pstat.h" /* <sys/stat.h> */

#include "zcontext.h"
#include "zalloc.h"
#include "zerror.h"
#include "zfile.h"

char *zReadFileString( struct zcontext_t *cnt, const char *fileName,
    const char *fileAlias, char *buf, int size)
{
  FILE *stream;
  struct stat statBuf;
  int length;

  if( fileAlias == NULL ) fileAlias = fileName;
  if( size > 0 ) size--;

  if( (stream = fopen( fileName, READ_T_MODE)) == NULL )
  {
    cnt->printError( cnt, zerFileOpen, fileAlias);
    return NULL;
  }

  if( fstat( fileno( stream ), &statBuf) != 0 )
  {
    if( size < 0 )
    {
      fclose( stream );
      cnt->printError( cnt, zerFileStat, fileAlias);
      return NULL;
    }
    else
      length = size;
  }
  else if( (length = (int) statBuf.st_size) < 0 )
  {
    if( size < 0 )
      length = 31 * 1024;
    else
      length = size;
  }
  else if( length > size )
    length = size;

  if( length == 0 )
  {
    fclose( stream );
    return (buf == NULL) ? zStrdup( cnt, "") : (*buf = '\0', buf);
  }
  if( buf == NULL ) 
    if( (buf = zMalloc( cnt, length + 1)) == NULL ) return NULL;

  if( (length = fread( buf, 1, length, stream)) < 0 )
  {
    zFree( cnt, buf);
    fclose( stream );
    cnt->printError( cnt, zerFileRead, fileAlias);
    return NULL;
  }

  fclose( stream );
  buf[length] = '\0';
  return buf;
}
