/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstdio.h" /* <stdio.h> */
#include "_pstring.h" /* <string.h> */

#include "zcontext.h"
#include "zerror.h"
#include "zalloc.h"
#include "zfile.h"

void zInitTempFile( struct ztempfile_t *tempFile )
{
  tempFile->name = NULL;
  tempFile->stream = NULL;
  tempFile->size = 0;
}

Boolean zOpenTempFile( struct zcontext_t *cnt, struct ztempfile_t *tempFile, const char *tempDir)
{
  char buf[ZMAX_FILE_NAME_SIZE];

  zInitTempFile( tempFile );
  if( (tempFile->stream = zTempFile( cnt, buf, sizeof( buf ), tempDir)) == NULL )
    return False;
  if( *buf != '\0' ) tempFile->name = zStrdup( cnt, buf);

  return True;
}

void zCloseTempFile( struct zcontext_t *cnt, struct ztempfile_t *tempFile)
{
  if( tempFile->stream != NULL ) fclose( tempFile->stream );
  if( tempFile->name != NULL )
  {
    unlink( tempFile->name );
    zFree( cnt, tempFile->name);
  }
  zInitTempFile( tempFile );
}

void zExchangeTempFile( struct ztempfile_t *temp1, struct ztempfile_t *temp2)
{
  struct ztempfile_t dummy;

  memcpy( &dummy, temp1, sizeof( struct ztempfile_t ));
  memcpy( temp1, temp2, sizeof( struct ztempfile_t ));
  memcpy( temp2, &dummy, sizeof( struct ztempfile_t ));
}
