/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstdio.h" /* <stdio.h> */
#include "_pstring.h" /* <string.h> */

#include "zcontext.h"
#include "zerror.h"
#include "zfile.h"

FILE *zTempFile( struct zcontext_t *cnt, char *buf, int bufSize, const char *tempDir)
{
  FILE *stream;

  if( tempDir == NULL )
  {
    *buf = '\0';
    if( (stream = tmpfile()) == NULL ) cnt->errorCode = zerTempFileOpen;
    return stream;
  }

  if( zMakeTempName( cnt, buf, bufSize, tempDir, False) == NULL )
  {
    cnt->errorCode = zerTempFileName;
    return NULL;
  }

  if( (stream = fopen( buf, cnt->tempFileTextMode ? WRITEREAD_T_MODE : WRITEREAD_B_MODE)) == NULL )
  {
    cnt->errorCode = zerTempFileOpen;
    return NULL;
  }

#if !defined( __MSDOS__ ) && !defined( __WIN32__ ) && !defined( __OS2__ )
  unlink( buf );
#endif
  return stream;
}
