/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */
#include <stdlib.h>

#include "zcontext.h"
#include "zerror.h"
#include "ztime.h"
#include "zfile.h"

#define MAX_FILE_NUMBER   __ZINT(100000)
#define MAX_FILE_COUNT    1000

char *zMakeTempName( struct zcontext_t *cnt, char *buf, int bufSize,
    const char *path, Boolean pathIsFile)
{
  char *ptr;
  int length, size = bufSize, retval;

  if( path != NULL && *path != '\0' )
  {
    if( pathIsFile )
    {
      if( (ptr = zFileName( path )) != NULL )
      {
	if( size <= (length = (int) (ptr - (char *) path)) )
        {
bad:      cnt->errorCode = zerBufferLimit;
          return NULL;
        }
        strncpy( buf, path, length);
        ptr = &buf[length];
        size -= length;
        ptr[0] = '\0';
      }
      else
        ptr = buf;
    }
    else
    {
      if( (length = strlen( path )) >= size ) goto bad;
      strcpy( buf, path);
      ptr = &buf[length];
      size -= length;
    }
    if( ptr != buf && *(ptr-1) != SLASH )
    {
      if( size <= 1 ) goto bad;
      *ptr ++ = SLASH;
      *ptr = '\0';
      size--;
    }
  }
  else
    ptr = buf;

  if( size <= 5 ) goto bad;
  if( size > 8 )
  {
    ptr[0] = 't';
    ptr[1] = 'm';
    ptr[2] = 'p';
    ptr[3] = '\0';
    ptr += 3;
    size -= 3;
  }

  if( cnt->tmpFileNumber == 0 )
  {
    cnt->tmpFileNumber = zGetTimeNumber( MAX_FILE_NUMBER - MAX_FILE_COUNT );
    cnt->tmpFileMaxCount = cnt->tmpFileNumber + MAX_FILE_COUNT;
  }

  if( size <= 9 )
    ptr[5] = '\0';
  else
  {
    ptr[5] = '.';
    ptr[6] = '$';
    ptr[7] = '$';
    ptr[8] = '$';
    ptr[9] = '\0';
  }

  for( cnt->tmpFileNumber++; cnt->tmpFileNumber < cnt->tmpFileMaxCount; cnt->tmpFileNumber++)
  {
    ptr[0] = (char) (((cnt->tmpFileNumber / 10000) % 10) + '0');
    ptr[1] = (char) (((cnt->tmpFileNumber / 1000) % 10) + '0');
    ptr[2] = (char) (((cnt->tmpFileNumber / 100) % 10) + '0');
    ptr[3] = (char) (((cnt->tmpFileNumber / 10) % 10) + '0');
    ptr[4] = (char) ((cnt->tmpFileNumber % 10) + '0');

    if( (retval = zFileExist( buf, fefExist, NULL)) == fesNotExist ) break;
    if( retval == fesStatError )
    {
      cnt->errorCode = zerTempFileStat;
      return NULL;
    }
  }

  if( cnt->tmpFileNumber == cnt->tmpFileMaxCount )
  {
    if( cnt->tmpFileSuccess )
    {
      cnt->tmpFileNumber = cnt->tmpFileMaxCount = 0;
      cnt->tmpFileSuccess = False;
      return zMakeTempName( cnt, buf, bufSize, path, pathIsFile);
    }
    /* XXX: cnt->errorCode = ???; */
    return NULL;
  }

  cnt->tmpFileSuccess = True;
  return buf;
}
