/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstat.h" /* <sys/stat.h> */
#include <errno.h>

#include "zfile.h"

int zFileExist( const char *path, unsigned char flags, void *pStatBuf)
{
  struct stat statBuf, *sb = (pStatBuf != NULL) ? (struct stat *) pStatBuf : &statBuf;

  if( stat( path, sb) != 0 )
  {
    if( errno == ENOENT ) return fesNotExist;
    if( errno == EACCES ) return fesPrefixRights;
#ifdef ENOTDIR
    if( errno == ENOTDIR ) return fesInvalidPrefix;
#endif
    return fesStatError;
  }

  if( (flags & fefFileExist) != 0 && (sb->st_mode & S_IFMT) != S_IFREG )
    return fesNotRegularFile;
  if( (flags & fefDirExist) != 0 && (sb->st_mode & S_IFMT) != S_IFDIR )
    return fesNotDirectory;

  return fesOk;
}
