/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */

#include "zfile.h"

char *zMakeFileName( char *buf, int size, const char *path1, const char *path2)
{
  int length;

  if( --size <= 0 )
  {
    if( size == 0 ) *buf = '\0';
    return buf;
  }

  if( path1 == NULL || *path1 == '\0' )
  {
    strncpy( buf, path2, size);
    buf[size] = '\0';
    return buf;
  }

  strncpy( buf, path1, size);
  buf[size] = '\0';

  if( (length = strlen( path1 )) >= size ) return buf;

  if( length > 0 && length < size && buf[length-1] != SLASH )
    buf[length++] = SLASH;

  if( length < size )
  {
    strncpy( &buf[length], path2, size-length);
    length = size;
  }

  buf[length] = '\0';
  return buf;
}
