/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstdio.h" /* <stdio.h> */
#include "_pstring.h" /* <string.h> */
#include <assert.h>

#include "zcontext.h"
#include "zfile.h"

Boolean zFileObjectSeek( struct zfileobject_t *fo, zoff_t offset)
{
#ifdef CHECK
  assert( offset >= 0 );
#endif

#if defined( USE_MMAP ) && defined( HAVE_MMAP )
  if( zCheckFlags( fo->flags, zfoMapped) )
  {
    if( (int) offset > fo->size )
    {
      fo->context->printError( fo->context, fo->errs[ZFILEOBJECT_ERRORCODE_EOF], fo->alias);
      return False;
    }
    fo->offset = (int) offset;
  }
  else
#endif
  {
    if( fseek( fo->stream, offset, SEEK_SET) != 0 )
    {
      fo->context->printError( fo->context, fo->errs[ZFILEOBJECT_ERRORCODE_SEEK], fo->alias);
      return False;
    }

#ifdef CHECK
    assert( ftell( fo->stream ) == offset );
#endif

#if defined( USE_MMAP ) && defined( HAVE_MMAP )
    fo->offset = (int) offset;
#else
    fo->offset = offset;
#endif
  }

  return True;
}

zoff_t zFileObjectTell( struct zfileobject_t *fo )
{
#if defined( USE_MMAP ) && defined( HAVE_MMAP )
  if( zCheckFlags( fo->flags, zfoMapped) )
  {
    return (zoff_t) fo->offset;
  }
  else
#endif
  {
    zoff_t offset;
    if( (offset = ftell( fo->stream )) < 0 )
      fo->context->printError( fo->context, fo->errs[ZFILEOBJECT_ERRORCODE_TELL], fo->alias);
    else
#if defined( USE_MMAP ) && defined( HAVE_MMAP )
      fo->offset = (int) offset;
#else
      fo->offset = offset;
#endif
    return offset;
  }
}

#ifdef __MSVC__
#pragma warning( disable: 4100)
#else
#pragma warn -par
#endif

unsigned char *zFileObjectRead( struct zfileobject_t *fo, unsigned char *buf, int length, Boolean virt)
{
  unsigned char *ptr = buf;

  if( length <= 0 ) return buf;

#if defined( USE_MMAP ) && defined( HAVE_MMAP )
  if( zCheckFlags( fo->flags, zfoMapped) )
  {
    if( fo->size <= fo->offset || length > fo->size - fo->offset )
    {
      fo->context->printError( fo->context, fo->errs[ZFILEOBJECT_ERRORCODE_EOF], fo->alias);
      return NULL;
    }
    if( virt )
      ptr = &fo->addr[fo->offset];
    else
      memcpy( buf, &fo->addr[fo->offset], length);
  }
  else
#endif
  {
    int n;

    if( (n = fread( buf, length, 1, fo->stream)) < 0 )
    {
      fo->context->printError( fo->context, fo->errs[ZFILEOBJECT_ERRORCODE_READ], fo->alias);
      return NULL;
    }
    else if( n != 1 )
    {
      fo->context->printError( fo->context, fo->errs[ZFILEOBJECT_ERRORCODE_EOF], fo->alias);
      return NULL;
    }
  }

  fo->offset += length;
  return ptr;
}

char *zFileObjectGets( struct zfileobject_t *fo, char *buf, int size, Boolean virt)
{
  unsigned char *ptr = (unsigned char *) buf;
  int length;

  if( --size <= 0 ) return NULL;
  fo->lastLength = 0;

#if defined( USE_MMAP ) && defined( HAVE_MMAP )
  if( zCheckFlags( fo->flags, zfoMapped) )
  {
    unsigned char *tmp;
    int rest;
    if( fo->size <= fo->offset ) return NULL;
    rest = fo->size - fo->offset;
    rest = ZMIN( rest, size);
    if( (tmp = (unsigned char *) memchr( &fo->addr[fo->offset], '\n', rest)) == NULL )
    {
      length = rest;
      memcpy( buf, &fo->addr[fo->offset], length);
      buf[length] = '\0';
    }
    else
    {
      length = (int) (tmp - &fo->addr[fo->offset]) + 1;
      if( virt )
        ptr = &fo->addr[fo->offset];
      else
      {
        memcpy( buf, &fo->addr[fo->offset], length);
        buf[length] = '\0';
      }
    }
  }
  else
#endif
  {
    if( fgets( buf, size+1, fo->stream) == NULL ) return NULL;
    /* XXX: ࠢ, ᫨  ⢨⥫쭮 室  fo->offset
             fo->lastLength */
    /* length = strlen( buf ); */
    length = 0;
  }

  fo->lastLength = length;
  fo->offset += length;
  return (char *) ptr;
}

#ifdef __MSVC__
#pragma warning( default: 4100)
#else
#pragma warn .par
#endif
