/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstdio.h" /* <stdio.h> */

#include "zcontext.h"
#include "zerror.h"
#include "zfile.h"

Boolean zRewriteFile( struct zcontext_t *cnt, const char *inFileName,
    const char *outFileName, zrewritefile_t rewrite, void *info)
{
  FILE *in, *out;
  char buf[1024];
  Boolean success, self = False;

  cnt->errorCode = zerNone;
  cnt->errorPtr = NULL;

  if( outFileName == NULL )
  {
    if( (outFileName = zMakeTempName( cnt, buf, sizeof( buf ), inFileName, True)) == NULL )
    {
      cnt->errorCode = zerTempFileName;
      return False;
    }
    self = True;
  }

  if( (in = fopen( inFileName, cnt->rewriteTextMode ? READ_T_MODE : READ_B_MODE)) == NULL )
  {
    cnt->errorCode = zerFileOpen;
    cnt->errorPtr = inFileName;
    return False;
  }
  zSetFileBuffer( in, NULL, Z_VBUF_SIZE);

  if( (out = fopen( outFileName, cnt->rewriteTextMode ? WRITE_T_MODE : WRITE_B_MODE)) == NULL )
  {
    fclose( in );
    cnt->errorCode = self ? zerTempFileOpen : zerFileOpen;
    cnt->errorPtr = outFileName;
    return False;
  }
  zSetFileBuffer( out, NULL, Z_VBUF_SIZE);

  success = rewrite( cnt, in, out, info);

  if( ferror( out ) )
  {
    success = False;
    cnt->errorCode = self ? zerTempFileWrite : zerFileWrite;
    cnt->errorPtr = outFileName;
    clearerr( out );
  }
  if( ferror( in ) )
  {
    success = False;
    cnt->errorCode = zerFileRead;
    cnt->errorPtr = inFileName;
    clearerr( in );
  }

  fclose( in );
  fclose( out );

  if( self )
    if( !success )
    {
      unlink( outFileName );
    }
    else
    {
#if defined( __MSDOS__ ) || defined( __WIN32__ ) || defined( __OS2__ )
      unlink( inFileName );
#endif
      if( rename( outFileName, inFileName) != 0 )
      {
        cnt->errorCode = zerTempFileRename;
        cnt->errorPtr = inFileName;
        success = False;
      }
    }

  return success;
}
