/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */

#include "zchars.h"
#include "zfile.h"

char *zFileName( const char *name )
{
  register char *s;

  if( (s = strrchr( name, SLASH)) != NULL ) return s+1;
#if defined( __OS2__ )
  if( (s = strchr( name, ':')) != NULL && s[1] != '\0' ) return s+1;
#elif defined( __MSDOS__ ) || defined( __WIN32__ )
  if( name[1] == ':' && isAlpha( name[0] ) ) return (char *) (name+2);
#endif

  return (char *) name;
}

Boolean zIsFullFileName( const char *name )
{
  if( *name == SLASH ) return True;
#if defined( __OS2__ )
  if( strchr( name, ':') != NULL ) return True;
#endif
#if defined( __MSDOS__ ) || defined( __WIN32__ )
  if( isAlpha( name[0] ) && name[1] == ':' ) return True;
#endif
  return False;
}
