/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"

#include "zcontext.h"
#include "zstdio.h"
#include "zerror.h"

ZDEF(const char * const) zErrorEnglishFormats[zecLastError+1] =
{
  /* zecNone                    */ "",
  /* zecInetArea                */ "",
  /* zecInternalError           */ "Internal error: file \"%.1000s\", line %d",
  /* zecExternalError           */ "External error: %.100s: %.1000s",
  /* zecInvalidValue            */ "Invalid argument(s) in function %.100s()",
  /* zecValueRange              */ "",
  /* zecSameValue               */ "",
  /* zecNotInited               */ "",
  /* zecNotSupported            */ "",
  /* zecNoMemory                */ "No more free memory (%.100s)",
  /* zecSystemTime              */ "Cann't get the system time",
  /* zecTimeValue               */ "",
  /* zecTimeString              */ "",
  /* zecUnknownCharset          */ "Unknown charset '%.100s'",
  /* zecBufferLimit             */ "",
  /* zecInvalidStringFormat     */ "",
  /* zecDataError               */ "",
  /* zecProcCreate              */ "Cann't create new process",
  /* zecTempFileName            */ "Cann't generate the name for the temporary file",
  /* zecZeroLengthFile          */ "Empty file \"%.1000s\"",
  /* zecUnexpectedFileEnd       */ "Unexpected end of the file \"%.1000s\"",
  /* zecFileFormat              */ "Invalid format of the file \"%.1000s\"",
  /* zecFileId                  */ "",
  /* zecFileSize                */ "The length of the file \"%.1000s\" is less than it stated in the header",
  /* zecFileLength              */ "The length of the file \"%.1000s\" is less than the header size",
  /* zecFileOpen                */ "Cann't open the file \"%.1000s\": %.100s",
  /* zecFileTell                */ "Ftell function failed for the file \"%.1000s\": %.100s",
  /* zecFileSeek                */ "Fseek function failed for the file \"%.1000s\": %.100s",
  /* zecFileStat                */ "Stat function failed for the file \"%.1000s\": %.100s",
  /* zecFileLock                */ "Cann't lock the file \"%.1000s\": %.100s",
  /* zecFileRead                */ "Cann't read the file \"%.1000s\": %.100s",
  /* zecFileWrite               */ "Cann't write the file \"%.1000s\": %.100s",
  /* zecFileRename              */ "Cann't rename the file \"%.1000s\" to \"%.1000s\": %.100s",
  /* zecFileAccess              */ "File \"%.1000s\": access denied",
  /* zecFileExist               */ "File \"%.1000s\" already exists",
  /* zecFileMmap                */ "Cann't create the memory map of the file \"%.1000s\": %.100s",
  /* zecFileDup                 */ "dup (or dup2) function failed for the file \"%.1000s\": %.100s",
  /* zecTempFileFormat          */ "Invalid format of the temporary file",
  /* zecTempFileOpen            */ "Cann't open the temporary file: %.100s",
  /* zecTempFileTell            */ "Ftell function failed for the temporary file: %.100s",
  /* zecTempFileSeek            */ "Fseek function failed for the temporary file: %.100s",
  /* zecTempFileStat            */ "Fstat function failed for the temporary file: %.100s",
  /* zecTempFileRead            */ "Cann't read the temporary file: %.100s",
  /* zecTempFileWrite           */ "Cann't write the temporary file: %.100s",
  /* zecTempFileRename          */ "Cann't rename temporary file to '%.1000s': %.100s",
  /* zecTempDirNotExist         */ "Directory for temporary files (%.1000s) does not exist",
  /* zecTempDirRights           */ "No rights to write into the temporary directory (%.1000s)",
  /* zecTempDirIsntDir          */ "\"%.1000s\" (the value for TempDir) isn't directory",
  /* zerPipeCreate              */ "Cann't create the pipe: %.100s",
  /* zecDirCreate               */ "Cann't create the directory \"%.1000s\": %.100s",
  /* zecDirOpen                 */ "Cann't open the directory \"%.1000s\": %.100s",
  /* zecNotDirectory            */ "The part of the path \".1000%s\" (or the whole path) isn't directory",
  /* zecNotRegularFile          */ "The file '%.1000s' is a special device",
  /* zecInvalidPattern          */ "The pattern '%.1000s' is invalid",
  /* zecConfFileOpen            */ "Cann't open the configuration file \"%.1000s\": %.100s",
  /* zecConfInvalidStringFormat */ "Invalid string format (number %d) in the configuration file \"%.1000s\"",
  /* zecConfUnknownSection      */ "Unknown section '%.100s' in the configuration file \"%.1000s\"",
  /* zecConfUnknownKeyword      */ "Unknown keyword '%.100s' in line %d of the configuration file \"%.1000s\"",
  /* zecConfInvalidValue        */ "Invalid value for '%.100s' in the configuration file \"%.1000s\", line %d",
  /* zecNeedRecursive           */ "You need recursive processing to deal with the pattern '%.1000s'",
  /* zecLastError               */ NULL
};

ZFUN(char *) zGetErrorString( struct zcontext_t *cnt, char *buffer, int size,
     unsigned zint_t errorCode, const char *name)
{
  const char * const *formats;
  char errbuf[100];
  int errc = _zErrorCode( errorCode );

  if( (formats = cnt->errorFormats) == NULL ) formats = zErrorEnglishFormats;

  if( zCheckFlags( errorCode, zefGeneral) )
    switch( errc )
    {
      case zecNone:
	*buffer = '\0';
        break;

      /* case zecInetArea: - 㥬 */
      /* case zecInvalidValue: - 㥬 */
      /* case zecValueRange: - 㥬 */
      /* case zecSameValue: - 㥬 */
      /* case zecNotInited: - 㥬 */
      /* case zecNotSupported: - 㥬 */
      /* case zecTimeValue: - 㥬 */
      /* case zecUndefinedDate: - 㥬 */
      /* case zecBufferLimit: - 㥬 */
      /* case zecInvalidStringFormat: - 㥬 */
      /* case zecDataError: - 㥬 */
      /* case zecFileId: - 㥬 */
      /* case zecFileSize: - 㥬 */
      /* case zecFileLength: - 㥬 */

      case zecInternalError:
        zsprintf( buffer, size, formats[errc], name, cnt->errorIntParam);
	break;

      case zecExternalError:
        zsprintf( buffer, size, formats[errc], name, cnt->errorStrParam);
	break;

      case zecInvalidValue:
      case zecNoMemory:
        zsprintf( buffer, size, formats[errc], name == NULL ? "???" : name);
        break;

      case zecSystemTime:
      case zecTempFileName:
      case zecTempFileFormat:
        zsprintf( buffer, size, formats[errc]);
        break;

      case zecProcCreate:
        zsprintf( buffer, size, "%s (%s): %s", formats[errc], name,
          (_zErrorCode( cnt->errorCode ) == zecNone ||
           _zErrorCode( cnt->errorCode ) == zecProcCreate) ?
          zSystemErrorString( errorCode, errbuf, sizeof( errbuf )) :
          formats[ _zErrorCode( cnt->errorCode ) ]);
        break;

      case zecUnknownCharset:
      case zecZeroLengthFile:
      case zecUnexpectedFileEnd:
      case zecFileFormat:
      case zecFileAccess:
      case zecFileExist:
      case zecNeedRecursive:
      case zecTempDirNotExist:
      case zecTempDirRights:
      case zecTempDirIsntDir:
      case zecNotDirectory:
      case zecNotRegularFile:
      case zecInvalidPattern:
        zsprintf( buffer, size, formats[errc], name);
        break;

      case zecFileOpen:
      case zecFileTell:
      case zecFileSeek:
      case zecFileStat:
      case zecFileLock:
      case zecFileRead:
      case zecFileWrite:
      case zecFileMmap:
      case zecFileDup:
      case zecTempFileRename:
      case zecDirCreate:
      case zecDirOpen:
      case zecConfFileOpen:
        zsprintf( buffer, size, formats[errc], name,
	  zSystemErrorString( errorCode, errbuf, sizeof( errbuf )));
	break;

      case zecFileRename:
	zsprintf( buffer, size, formats[errc], name, cnt->errorPtr,
	  zSystemErrorString( errorCode, errbuf, sizeof( errbuf )));
	break;

      case zecTempFileOpen:
      case zecTempFileTell:
      case zecTempFileSeek:
      case zecTempFileStat:
      case zecTempFileRead:
      case zecTempFileWrite:
      case zecPipeCreate:
	zsprintf( buffer, size, formats[errc],
	  zSystemErrorString( errorCode, errbuf, sizeof( errbuf )));
	break;

      case zecConfInvalidStringFormat:
	zsprintf( buffer, size, formats[errc], cnt->errorIntParam, name);
	break;

      case zecConfUnknownSection:
	zsprintf( buffer, size, formats[errc], cnt->errorStrParam, name);
	break;

      case zecConfUnknownKeyword:
	zsprintf( buffer, size, formats[errc], cnt->errorStrParam, cnt->errorIntParam, name);
	break;

      case zecConfInvalidValue:
	zsprintf( buffer, size, formats[errc], cnt->errorStrParam, name, cnt->errorIntParam);
	break;

      default:
	zsprintf( buffer, size, "??? (#%d)", errc);
	break;
    }
  else
    zsprintf( buffer, size, "??? (%d)", errc);

  return buffer;
}
