/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */
#include <errno.h>
#if defined( __WIN32__ ) && defined( HAVE_GET_LAST_ERROR )
#include "_pwin.h"
#endif

#include "zcontext.h"
#include "zchars.h"
#include "zcharset.h"
#include "zerror.h"

#ifdef __MSVC__
#pragma warning( disable: 4100)
#else
#pragma warn -par
#endif

void zDefaultPrintError( struct zcontext_t *cnt, unsigned zint_t errorCode, const char *name)
{
}

ZFUN(void) zSetErrorHandler( struct zcontext_t *cnt, zprinterror_t handler)
{
  if( handler == NULL )
    cnt->printError = zDefaultPrintError;
  else
    cnt->printError = handler;
}

ZFUN(char *) zSystemErrorString( unsigned zint_t errorCode, char *buf, int size)
{
  if( size <= 0 || buf == NULL ) return "";

#if defined( __WIN32__ ) && defined( HAVE_GET_LAST_ERROR )
  if( zCheckFlags( errorCode, zefSystem) )
  {
    FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, GetLastError(),
      MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT), buf, size, NULL);

#ifdef RUSSIAN_SUPPORT
    /* 饭 -  㧮᪮ ஢!   ᥣ ,   ... */
    {
      int charset = LOCAL_CHARSET;
      if( charset != ZCHARSET_CYR_WIN && zCharsetValid( charset ) )
      {
        char *table = win2anyTables[charset];
        if( table != NULL ) zRecode8( buf, table);
      }
    }
#endif

    /*  ⮣,   buf   "\n\r",  ᮢ襭 㦠᭮
       룫廊  뢮  䠩 :( */
    {
      register int length = strlen( buf );
      for( ; length > 0 && isSpace( buf[length-1] ); length--) buf[length-1] = '\0';
    }
  }
  else
#endif
  {
    char *s;
    if( (s = strerror( errno )) == NULL )
      *buf = '\0';
    else
    {
      strncpy( buf, s, size);
      buf[size-1] = '\0';
    }
  }

  return buf;
}

#ifdef __MSVC__
#pragma warning( default: 4100)
#else
#pragma warn .par
#endif
