/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstdio.h" /* <stdio.h> */
#include "_pstring.h" /* <string.h> */
#include <stdarg.h>

#include "zcontext.h"
#include "zstdio.h"
#include "zdebug.h"

void zDebugInit( struct zcontext_t *cnt, int level, unsigned zint_t area, FILE *stream)
{
  cnt->debugLevel = level;
  cnt->debugArea = area;
  cnt->debugStream = stream;
}

void zdebug( struct zcontext_t *cnt, int target, const char *fmt, ...)
{
  va_list args;
  struct zioinfo_t ioInfo;
  char startChar;

  zioSetOutputStream( cnt, (cnt->debugStream == NULL) ? stdout : cnt->debugStream, &ioInfo);

  switch( target )
  {
    case ZDEBUG_TARGET_IN:    startChar = '>'; break;
    case ZDEBUG_TARGET_OUT:   startChar = '<'; break;
    case ZDEBUG_TARGET_ARGS:  startChar = ':'; break;
    case ZDEBUG_TARGET_ALARM: startChar = '!'; break;
    default:                  startChar = '.'; break;
  }

  /* XXX:  ᬮ, 室     ப   */
  zprintf( cnt, "%s`%.*c%c ", "", cnt->debugProgLevel * 3, ' ', startChar);

  va_start( args, fmt);
  zvprintf( cnt, fmt, args);
  va_end( args );

  zprintf( cnt, "\n");
  zflush( cnt );
  zioRestoreInfo( cnt, &ioInfo);
}
