/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */
#if defined( __MSVC__ )
#include "_pwin.h" /* <windows.h> */
#endif
#if defined( ZCHECK_MEMORY_ALLOCATIONS )
#include <assert.h>
#endif

#include "zcontext.h"
#include "zcharset.h"
#include "zerror.h"
#if defined( ZCHECK_MEMORY_ALLOCATIONS )
#include "zstdio.h"
#endif

ZFUN(Boolean) zContextInit( struct zcontext_t *cnt, zprinterror_t printError,
    const char * const *errorFormats, zmemfail_t memFail, unsigned int flags)
{
  ZEROFILL( cnt, sizeof( struct zcontext_t ));

  zSetErrorHandler( cnt, printError);
  cnt->errorFormats = errorFormats;
  cnt->allocFail = memFail;
  cnt->confSuccess = True;
  cnt->localCharset = cnt->remoteCharset = ZCHARSET_UNKNOWN;
  zSetFlags( cnt->ioFlags, ZCONTEXT_IOFLAG_STRICT_VALUE);
  cnt->language = zlnEnglish;
  cnt->localCharset = LOCAL_CHARSET;
#ifdef RUSSIAN_SUPPORT
  if( !zCharsetValid( cnt->localCharset ) ) cnt->localCharset = ZCHARSET_CYR_WIN;
#endif
#if defined( __MSVC__ )
  cnt->hHeap = (unsigned long) NULL;
#endif

  if( zCheckFlags( flags, zciCreateHeap) )
  {
#if defined( __MSVC__ )
    if( (cnt->hHeap = (unsigned long) HeapCreate( HEAP_NO_SERIALIZE,
           zCheckFlags( flags, zciHeapSerialize) ? 0 : HEAP_NO_SERIALIZE, 0)) == (unsigned long) NULL )
    {
      cnt->errorCode = zerNoMemory | zefSystem;
      return False;
    }
#endif
  }

  return True;
}

ZFUN(void) zContextCopy( struct zcontext_t *dest, struct zcontext_t *src)
{
  memcpy( dest, src, sizeof(struct zcontext_t));
}

ZFUN(void) zContextFree( struct zcontext_t *cnt )
{
#if defined( __MSVC__ )
  if( cnt->hHeap != (unsigned long) NULL )
  {
    HeapDestroy( (HANDLE) cnt->hHeap );
    cnt->hHeap = (unsigned long) NULL;
#if defined( ZCHECK_MEMORY_ALLOCATIONS )
    cnt->allocCount = 0;
#endif
  }
#endif

#if defined( ZCHECK_MEMORY_ALLOCATIONS )
  zflush( cnt );
  assert( cnt->allocCount == 0 );
#endif
}
