/*
    LIBZ
    Copyright (C) 1998, 2000  VVK (valera@sbnet.ru), CNII Center, Moscow

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "zdefs.h"
#include "_pstring.h" /* <string.h> */

#include "zcontext.h"
#include "zerror.h"
#include "zconfig.h"

#ifdef __MSVC__
#pragma warning( disable: 4100)
#else
#pragma warn -par
#endif

Boolean zInitDefaultConfig( struct zcontext_t *cnt, struct zconfsec_t *cs,
    unsigned int flags, const char *fileName, void *data)
{
  cnt->confSection = cs;
  cnt->confAreaFlags = flags;
  cnt->confName = fileName;
  return True;
}

void zFinishDefaultConfig( struct zcontext_t *cnt, Boolean success, Boolean hasValue, void *data)
{
  if( !success ) cnt->confSuccess = False;
  cnt->confSection = NULL;
  cnt->confAreaFlags = 0;
  cnt->confName = NULL;
}

#ifdef __MSVC__
#pragma warning( default: 4100)
#else
#pragma warn .par
#endif

Boolean zProcessDefaultConfig( struct zcontext_t *cnt, char *line, void *data)
{
  switch( zProcessConfig( cnt, line, cnt->confSection->table, cnt->confAreaFlags, data) )
  {
    case zpcNoDelimiter:
    case zpcNoKeyword:
    case zpcNotClosed:
    case zpcUnknown:
      cnt->confSuccess = False;
      cnt->errorIntParam = cnt->confLineNumber;
      cnt->printError( cnt, (cnt->confErrors == NULL) ? zerConfInvalidStringFormat :
        cnt->confErrors[ZCONFERR_INVALID_STRING_FORMAT], cnt->confName);
      return True;
    case zpcUnknownKeyword:
      cnt->confSuccess = False;
      cnt->errorIntParam = cnt->confLineNumber;
      cnt->printError( cnt, (cnt->confErrors == NULL) ? zerConfUnknownKeyword :
        cnt->confErrors[ZCONFERR_UNKNOWN_KEYWORD], cnt->confName);
      return True;
    case zpcInvalidValue:
      cnt->confSuccess = False;
      cnt->errorIntParam = cnt->confLineNumber;
      cnt->printError( cnt, (cnt->confErrors == NULL) ? zerConfInvalidValue :
	cnt->confErrors[ZCONFERR_INVALID_VALUE], cnt->confName);
      return True;
    case zpcNoMemory:
      cnt->confSuccess = False;
      cnt->printError( cnt, zerNoMemory, NULL);
      return False;
    case zpcNotOk:
      cnt->confSuccess = False;
      return False;
    default:
      return True;
  }
}
